package zio.aws.connect.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.connect.model.primitives.{MaxResult1000, NextToken, InstanceId}
import scala.jdk.CollectionConverters._
final case class ListAgentStatusesRequest(
    instanceId: InstanceId,
    nextToken: Option[NextToken] = None,
    maxResults: Option[MaxResult1000] = None,
    agentStatusTypes: Option[Iterable[zio.aws.connect.model.AgentStatusType]] =
      None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connect.model.ListAgentStatusesRequest = {
    import ListAgentStatusesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connect.model.ListAgentStatusesRequest
      .builder()
      .instanceId(InstanceId.unwrap(instanceId): java.lang.String)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value => MaxResult1000.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        agentStatusTypes.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.agentStatusTypesWithStrings)
      .build()
  }
  def asReadOnly: zio.aws.connect.model.ListAgentStatusesRequest.ReadOnly =
    zio.aws.connect.model.ListAgentStatusesRequest.wrap(buildAwsValue())
}
object ListAgentStatusesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connect.model.ListAgentStatusesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connect.model.ListAgentStatusesRequest =
      zio.aws.connect.model.ListAgentStatusesRequest(
        instanceId,
        nextToken.map(value => value),
        maxResults.map(value => value),
        agentStatusTypes.map(value => value)
      )
    def instanceId: InstanceId
    def nextToken: Option[NextToken]
    def maxResults: Option[MaxResult1000]
    def agentStatusTypes: Option[List[zio.aws.connect.model.AgentStatusType]]
    def getInstanceId: ZIO[Any, Nothing, InstanceId] = ZIO.succeed(instanceId)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, MaxResult1000] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getAgentStatusTypes
        : ZIO[Any, AwsError, List[zio.aws.connect.model.AgentStatusType]] =
      AwsError.unwrapOptionField("agentStatusTypes", agentStatusTypes)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connect.model.ListAgentStatusesRequest
  ) extends zio.aws.connect.model.ListAgentStatusesRequest.ReadOnly {
    override val instanceId: InstanceId =
      zio.aws.connect.model.primitives.InstanceId(impl.instanceId())
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.connect.model.primitives.NextToken(value))
    override val maxResults: Option[MaxResult1000] = scala
      .Option(impl.maxResults())
      .map(value => zio.aws.connect.model.primitives.MaxResult1000(value))
    override val agentStatusTypes
        : Option[List[zio.aws.connect.model.AgentStatusType]] = scala
      .Option(impl.agentStatusTypes())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.connect.model.AgentStatusType.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.connect.model.ListAgentStatusesRequest
  ): zio.aws.connect.model.ListAgentStatusesRequest.ReadOnly = new Wrapper(impl)
}
