package zio.aws.connect.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.connect.model.primitives.{MaxResult25, NextToken, InstanceId}
import scala.jdk.CollectionConverters._
final case class ListApprovedOriginsRequest(
    instanceId: InstanceId,
    nextToken: Option[NextToken] = None,
    maxResults: Option[MaxResult25] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connect.model.ListApprovedOriginsRequest = {
    import ListApprovedOriginsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connect.model.ListApprovedOriginsRequest
      .builder()
      .instanceId(InstanceId.unwrap(instanceId): java.lang.String)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value => MaxResult25.unwrap(value): Integer)
      )(_.maxResults)
      .build()
  }
  def asReadOnly: zio.aws.connect.model.ListApprovedOriginsRequest.ReadOnly =
    zio.aws.connect.model.ListApprovedOriginsRequest.wrap(buildAwsValue())
}
object ListApprovedOriginsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connect.model.ListApprovedOriginsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connect.model.ListApprovedOriginsRequest =
      zio.aws.connect.model.ListApprovedOriginsRequest(
        instanceId,
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def instanceId: InstanceId
    def nextToken: Option[NextToken]
    def maxResults: Option[MaxResult25]
    def getInstanceId: ZIO[Any, Nothing, InstanceId] = ZIO.succeed(instanceId)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, MaxResult25] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connect.model.ListApprovedOriginsRequest
  ) extends zio.aws.connect.model.ListApprovedOriginsRequest.ReadOnly {
    override val instanceId: InstanceId =
      zio.aws.connect.model.primitives.InstanceId(impl.instanceId())
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.connect.model.primitives.NextToken(value))
    override val maxResults: Option[MaxResult25] = scala
      .Option(impl.maxResults())
      .map(value => zio.aws.connect.model.primitives.MaxResult25(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.connect.model.ListApprovedOriginsRequest
  ): zio.aws.connect.model.ListApprovedOriginsRequest.ReadOnly = new Wrapper(
    impl
  )
}
