package zio.aws.connect.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.connect.model.primitives.{MaxResult25, NextToken, InstanceId}
import scala.jdk.CollectionConverters._
final case class ListBotsRequest(
    instanceId: InstanceId,
    nextToken: Option[NextToken] = None,
    maxResults: Option[MaxResult25] = None,
    lexVersion: zio.aws.connect.model.LexVersion
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connect.model.ListBotsRequest = {
    import ListBotsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connect.model.ListBotsRequest
      .builder()
      .instanceId(InstanceId.unwrap(instanceId): java.lang.String)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value => MaxResult25.unwrap(value): Integer)
      )(_.maxResults)
      .lexVersion(lexVersion.unwrap)
      .build()
  }
  def asReadOnly: zio.aws.connect.model.ListBotsRequest.ReadOnly =
    zio.aws.connect.model.ListBotsRequest.wrap(buildAwsValue())
}
object ListBotsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connect.model.ListBotsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connect.model.ListBotsRequest =
      zio.aws.connect.model.ListBotsRequest(
        instanceId,
        nextToken.map(value => value),
        maxResults.map(value => value),
        lexVersion
      )
    def instanceId: InstanceId
    def nextToken: Option[NextToken]
    def maxResults: Option[MaxResult25]
    def lexVersion: zio.aws.connect.model.LexVersion
    def getInstanceId: ZIO[Any, Nothing, InstanceId] = ZIO.succeed(instanceId)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, MaxResult25] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getLexVersion: ZIO[Any, Nothing, zio.aws.connect.model.LexVersion] =
      ZIO.succeed(lexVersion)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connect.model.ListBotsRequest
  ) extends zio.aws.connect.model.ListBotsRequest.ReadOnly {
    override val instanceId: InstanceId =
      zio.aws.connect.model.primitives.InstanceId(impl.instanceId())
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.connect.model.primitives.NextToken(value))
    override val maxResults: Option[MaxResult25] = scala
      .Option(impl.maxResults())
      .map(value => zio.aws.connect.model.primitives.MaxResult25(value))
    override val lexVersion: zio.aws.connect.model.LexVersion =
      zio.aws.connect.model.LexVersion.wrap(impl.lexVersion())
  }
  def wrap(
      impl: software.amazon.awssdk.services.connect.model.ListBotsRequest
  ): zio.aws.connect.model.ListBotsRequest.ReadOnly = new Wrapper(impl)
}
