package zio.aws.connect.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.connect.model.primitives.NextToken
import scala.jdk.CollectionConverters._
final case class ListBotsResponse(
    lexBots: Option[Iterable[zio.aws.connect.model.LexBotConfig]] = None,
    nextToken: Option[NextToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connect.model.ListBotsResponse = {
    import ListBotsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connect.model.ListBotsResponse
      .builder()
      .optionallyWith(
        lexBots.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.lexBots)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.connect.model.ListBotsResponse.ReadOnly =
    zio.aws.connect.model.ListBotsResponse.wrap(buildAwsValue())
}
object ListBotsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connect.model.ListBotsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connect.model.ListBotsResponse =
      zio.aws.connect.model.ListBotsResponse(
        lexBots.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def lexBots: Option[List[zio.aws.connect.model.LexBotConfig.ReadOnly]]
    def nextToken: Option[NextToken]
    def getLexBots: ZIO[Any, AwsError, List[
      zio.aws.connect.model.LexBotConfig.ReadOnly
    ]] = AwsError.unwrapOptionField("lexBots", lexBots)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connect.model.ListBotsResponse
  ) extends zio.aws.connect.model.ListBotsResponse.ReadOnly {
    override val lexBots
        : Option[List[zio.aws.connect.model.LexBotConfig.ReadOnly]] = scala
      .Option(impl.lexBots())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.connect.model.LexBotConfig.wrap(item)
        }.toList
      )
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.connect.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.connect.model.ListBotsResponse
  ): zio.aws.connect.model.ListBotsResponse.ReadOnly = new Wrapper(impl)
}
