package zio.aws.connect.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.connect.model.primitives.{MaxResult1000, NextToken, InstanceId}
import scala.jdk.CollectionConverters._
final case class ListContactFlowModulesRequest(
    instanceId: InstanceId,
    nextToken: Option[NextToken] = None,
    maxResults: Option[MaxResult1000] = None,
    contactFlowModuleState: Option[
      zio.aws.connect.model.ContactFlowModuleState
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connect.model.ListContactFlowModulesRequest = {
    import ListContactFlowModulesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connect.model.ListContactFlowModulesRequest
      .builder()
      .instanceId(InstanceId.unwrap(instanceId): java.lang.String)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value => MaxResult1000.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(contactFlowModuleState.map(value => value.unwrap))(
        _.contactFlowModuleState
      )
      .build()
  }
  def asReadOnly: zio.aws.connect.model.ListContactFlowModulesRequest.ReadOnly =
    zio.aws.connect.model.ListContactFlowModulesRequest.wrap(buildAwsValue())
}
object ListContactFlowModulesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connect.model.ListContactFlowModulesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connect.model.ListContactFlowModulesRequest =
      zio.aws.connect.model.ListContactFlowModulesRequest(
        instanceId,
        nextToken.map(value => value),
        maxResults.map(value => value),
        contactFlowModuleState.map(value => value)
      )
    def instanceId: InstanceId
    def nextToken: Option[NextToken]
    def maxResults: Option[MaxResult1000]
    def contactFlowModuleState
        : Option[zio.aws.connect.model.ContactFlowModuleState]
    def getInstanceId: ZIO[Any, Nothing, InstanceId] = ZIO.succeed(instanceId)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, MaxResult1000] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getContactFlowModuleState
        : ZIO[Any, AwsError, zio.aws.connect.model.ContactFlowModuleState] =
      AwsError.unwrapOptionField(
        "contactFlowModuleState",
        contactFlowModuleState
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connect.model.ListContactFlowModulesRequest
  ) extends zio.aws.connect.model.ListContactFlowModulesRequest.ReadOnly {
    override val instanceId: InstanceId =
      zio.aws.connect.model.primitives.InstanceId(impl.instanceId())
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.connect.model.primitives.NextToken(value))
    override val maxResults: Option[MaxResult1000] = scala
      .Option(impl.maxResults())
      .map(value => zio.aws.connect.model.primitives.MaxResult1000(value))
    override val contactFlowModuleState
        : Option[zio.aws.connect.model.ContactFlowModuleState] = scala
      .Option(impl.contactFlowModuleState())
      .map(value => zio.aws.connect.model.ContactFlowModuleState.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.connect.model.ListContactFlowModulesRequest
  ): zio.aws.connect.model.ListContactFlowModulesRequest.ReadOnly = new Wrapper(
    impl
  )
}
