package zio.aws.connect.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.connect.model.primitives.NextToken
import scala.jdk.CollectionConverters._
final case class ListContactFlowsResponse(
    contactFlowSummaryList: Option[
      Iterable[zio.aws.connect.model.ContactFlowSummary]
    ] = None,
    nextToken: Option[NextToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connect.model.ListContactFlowsResponse = {
    import ListContactFlowsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connect.model.ListContactFlowsResponse
      .builder()
      .optionallyWith(
        contactFlowSummaryList.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.contactFlowSummaryList)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.connect.model.ListContactFlowsResponse.ReadOnly =
    zio.aws.connect.model.ListContactFlowsResponse.wrap(buildAwsValue())
}
object ListContactFlowsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connect.model.ListContactFlowsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connect.model.ListContactFlowsResponse =
      zio.aws.connect.model.ListContactFlowsResponse(
        contactFlowSummaryList.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def contactFlowSummaryList
        : Option[List[zio.aws.connect.model.ContactFlowSummary.ReadOnly]]
    def nextToken: Option[NextToken]
    def getContactFlowSummaryList: ZIO[Any, AwsError, List[
      zio.aws.connect.model.ContactFlowSummary.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "contactFlowSummaryList",
      contactFlowSummaryList
    )
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connect.model.ListContactFlowsResponse
  ) extends zio.aws.connect.model.ListContactFlowsResponse.ReadOnly {
    override val contactFlowSummaryList
        : Option[List[zio.aws.connect.model.ContactFlowSummary.ReadOnly]] =
      scala
        .Option(impl.contactFlowSummaryList())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.connect.model.ContactFlowSummary.wrap(item)
          }.toList
        )
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.connect.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.connect.model.ListContactFlowsResponse
  ): zio.aws.connect.model.ListContactFlowsResponse.ReadOnly = new Wrapper(impl)
}
