package zio.aws.connect.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.connect.model.primitives.{NextToken, ContactId, InstanceId}
import scala.jdk.CollectionConverters._
final case class ListContactReferencesRequest(
    instanceId: InstanceId,
    contactId: ContactId,
    referenceTypes: Iterable[zio.aws.connect.model.ReferenceType],
    nextToken: Option[NextToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connect.model.ListContactReferencesRequest = {
    import ListContactReferencesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connect.model.ListContactReferencesRequest
      .builder()
      .instanceId(InstanceId.unwrap(instanceId): java.lang.String)
      .contactId(ContactId.unwrap(contactId): java.lang.String)
      .referenceTypesWithStrings(referenceTypes.map { item =>
        item.unwrap.toString
      }.asJavaCollection)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.connect.model.ListContactReferencesRequest.ReadOnly =
    zio.aws.connect.model.ListContactReferencesRequest.wrap(buildAwsValue())
}
object ListContactReferencesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connect.model.ListContactReferencesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connect.model.ListContactReferencesRequest =
      zio.aws.connect.model.ListContactReferencesRequest(
        instanceId,
        contactId,
        referenceTypes,
        nextToken.map(value => value)
      )
    def instanceId: InstanceId
    def contactId: ContactId
    def referenceTypes: List[zio.aws.connect.model.ReferenceType]
    def nextToken: Option[NextToken]
    def getInstanceId: ZIO[Any, Nothing, InstanceId] = ZIO.succeed(instanceId)
    def getContactId: ZIO[Any, Nothing, ContactId] = ZIO.succeed(contactId)
    def getReferenceTypes
        : ZIO[Any, Nothing, List[zio.aws.connect.model.ReferenceType]] =
      ZIO.succeed(referenceTypes)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connect.model.ListContactReferencesRequest
  ) extends zio.aws.connect.model.ListContactReferencesRequest.ReadOnly {
    override val instanceId: InstanceId =
      zio.aws.connect.model.primitives.InstanceId(impl.instanceId())
    override val contactId: ContactId =
      zio.aws.connect.model.primitives.ContactId(impl.contactId())
    override val referenceTypes: List[zio.aws.connect.model.ReferenceType] =
      impl
        .referenceTypes()
        .asScala
        .map { item =>
          zio.aws.connect.model.ReferenceType.wrap(item)
        }
        .toList
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.connect.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.connect.model.ListContactReferencesRequest
  ): zio.aws.connect.model.ListContactReferencesRequest.ReadOnly = new Wrapper(
    impl
  )
}
