package zio.aws.connect.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.connect.model.primitives.NextToken
import scala.jdk.CollectionConverters._
final case class ListContactReferencesResponse(
    referenceSummaryList: Option[
      Iterable[zio.aws.connect.model.ReferenceSummary]
    ] = None,
    nextToken: Option[NextToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connect.model.ListContactReferencesResponse = {
    import ListContactReferencesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connect.model.ListContactReferencesResponse
      .builder()
      .optionallyWith(
        referenceSummaryList.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.referenceSummaryList)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.connect.model.ListContactReferencesResponse.ReadOnly =
    zio.aws.connect.model.ListContactReferencesResponse.wrap(buildAwsValue())
}
object ListContactReferencesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connect.model.ListContactReferencesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connect.model.ListContactReferencesResponse =
      zio.aws.connect.model.ListContactReferencesResponse(
        referenceSummaryList.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def referenceSummaryList
        : Option[List[zio.aws.connect.model.ReferenceSummary.ReadOnly]]
    def nextToken: Option[NextToken]
    def getReferenceSummaryList: ZIO[Any, AwsError, List[
      zio.aws.connect.model.ReferenceSummary.ReadOnly
    ]] =
      AwsError.unwrapOptionField("referenceSummaryList", referenceSummaryList)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connect.model.ListContactReferencesResponse
  ) extends zio.aws.connect.model.ListContactReferencesResponse.ReadOnly {
    override val referenceSummaryList
        : Option[List[zio.aws.connect.model.ReferenceSummary.ReadOnly]] = scala
      .Option(impl.referenceSummaryList())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.connect.model.ReferenceSummary.wrap(item)
        }.toList
      )
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.connect.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.connect.model.ListContactReferencesResponse
  ): zio.aws.connect.model.ListContactReferencesResponse.ReadOnly = new Wrapper(
    impl
  )
}
