package zio.aws.connect.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.connect.model.primitives.NextToken
import scala.jdk.CollectionConverters._
final case class ListInstanceAttributesResponse(
    attributes: Option[Iterable[zio.aws.connect.model.Attribute]] = None,
    nextToken: Option[NextToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connect.model.ListInstanceAttributesResponse = {
    import ListInstanceAttributesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connect.model.ListInstanceAttributesResponse
      .builder()
      .optionallyWith(
        attributes.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.attributes)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.connect.model.ListInstanceAttributesResponse.ReadOnly =
    zio.aws.connect.model.ListInstanceAttributesResponse.wrap(buildAwsValue())
}
object ListInstanceAttributesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connect.model.ListInstanceAttributesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connect.model.ListInstanceAttributesResponse =
      zio.aws.connect.model.ListInstanceAttributesResponse(
        attributes.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def attributes: Option[List[zio.aws.connect.model.Attribute.ReadOnly]]
    def nextToken: Option[NextToken]
    def getAttributes
        : ZIO[Any, AwsError, List[zio.aws.connect.model.Attribute.ReadOnly]] =
      AwsError.unwrapOptionField("attributes", attributes)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connect.model.ListInstanceAttributesResponse
  ) extends zio.aws.connect.model.ListInstanceAttributesResponse.ReadOnly {
    override val attributes
        : Option[List[zio.aws.connect.model.Attribute.ReadOnly]] = scala
      .Option(impl.attributes())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.connect.model.Attribute.wrap(item)
        }.toList
      )
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.connect.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.connect.model.ListInstanceAttributesResponse
  ): zio.aws.connect.model.ListInstanceAttributesResponse.ReadOnly =
    new Wrapper(impl)
}
