package zio.aws.connect.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.connect.model.primitives.{MaxResult10, NextToken}
import scala.jdk.CollectionConverters._
final case class ListInstancesRequest(
    nextToken: Option[NextToken] = None,
    maxResults: Option[MaxResult10] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connect.model.ListInstancesRequest = {
    import ListInstancesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connect.model.ListInstancesRequest
      .builder()
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value => MaxResult10.unwrap(value): Integer)
      )(_.maxResults)
      .build()
  }
  def asReadOnly: zio.aws.connect.model.ListInstancesRequest.ReadOnly =
    zio.aws.connect.model.ListInstancesRequest.wrap(buildAwsValue())
}
object ListInstancesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connect.model.ListInstancesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connect.model.ListInstancesRequest =
      zio.aws.connect.model.ListInstancesRequest(
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def nextToken: Option[NextToken]
    def maxResults: Option[MaxResult10]
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, MaxResult10] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connect.model.ListInstancesRequest
  ) extends zio.aws.connect.model.ListInstancesRequest.ReadOnly {
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.connect.model.primitives.NextToken(value))
    override val maxResults: Option[MaxResult10] = scala
      .Option(impl.maxResults())
      .map(value => zio.aws.connect.model.primitives.MaxResult10(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.connect.model.ListInstancesRequest
  ): zio.aws.connect.model.ListInstancesRequest.ReadOnly = new Wrapper(impl)
}
