package zio.aws.connect.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.connect.model.primitives.{MaxResult100, NextToken, InstanceId}
import scala.jdk.CollectionConverters._
final case class ListIntegrationAssociationsRequest(
    instanceId: InstanceId,
    integrationType: Option[zio.aws.connect.model.IntegrationType] = None,
    nextToken: Option[NextToken] = None,
    maxResults: Option[MaxResult100] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connect.model.ListIntegrationAssociationsRequest = {
    import ListIntegrationAssociationsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connect.model.ListIntegrationAssociationsRequest
      .builder()
      .instanceId(InstanceId.unwrap(instanceId): java.lang.String)
      .optionallyWith(integrationType.map(value => value.unwrap))(
        _.integrationType
      )
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value => MaxResult100.unwrap(value): Integer)
      )(_.maxResults)
      .build()
  }
  def asReadOnly
      : zio.aws.connect.model.ListIntegrationAssociationsRequest.ReadOnly =
    zio.aws.connect.model.ListIntegrationAssociationsRequest
      .wrap(buildAwsValue())
}
object ListIntegrationAssociationsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connect.model.ListIntegrationAssociationsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connect.model.ListIntegrationAssociationsRequest =
      zio.aws.connect.model.ListIntegrationAssociationsRequest(
        instanceId,
        integrationType.map(value => value),
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def instanceId: InstanceId
    def integrationType: Option[zio.aws.connect.model.IntegrationType]
    def nextToken: Option[NextToken]
    def maxResults: Option[MaxResult100]
    def getInstanceId: ZIO[Any, Nothing, InstanceId] = ZIO.succeed(instanceId)
    def getIntegrationType
        : ZIO[Any, AwsError, zio.aws.connect.model.IntegrationType] =
      AwsError.unwrapOptionField("integrationType", integrationType)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, MaxResult100] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connect.model.ListIntegrationAssociationsRequest
  ) extends zio.aws.connect.model.ListIntegrationAssociationsRequest.ReadOnly {
    override val instanceId: InstanceId =
      zio.aws.connect.model.primitives.InstanceId(impl.instanceId())
    override val integrationType
        : Option[zio.aws.connect.model.IntegrationType] = scala
      .Option(impl.integrationType())
      .map(value => zio.aws.connect.model.IntegrationType.wrap(value))
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.connect.model.primitives.NextToken(value))
    override val maxResults: Option[MaxResult100] = scala
      .Option(impl.maxResults())
      .map(value => zio.aws.connect.model.primitives.MaxResult100(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.connect.model.ListIntegrationAssociationsRequest
  ): zio.aws.connect.model.ListIntegrationAssociationsRequest.ReadOnly =
    new Wrapper(impl)
}
