package zio.aws.connect.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.connect.model.primitives.{NextToken, FunctionArn}
import scala.jdk.CollectionConverters._
final case class ListLambdaFunctionsResponse(
    lambdaFunctions: Option[Iterable[FunctionArn]] = None,
    nextToken: Option[NextToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connect.model.ListLambdaFunctionsResponse = {
    import ListLambdaFunctionsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connect.model.ListLambdaFunctionsResponse
      .builder()
      .optionallyWith(
        lambdaFunctions.map(value =>
          value.map { item =>
            FunctionArn.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.lambdaFunctions)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.connect.model.ListLambdaFunctionsResponse.ReadOnly =
    zio.aws.connect.model.ListLambdaFunctionsResponse.wrap(buildAwsValue())
}
object ListLambdaFunctionsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connect.model.ListLambdaFunctionsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connect.model.ListLambdaFunctionsResponse =
      zio.aws.connect.model.ListLambdaFunctionsResponse(
        lambdaFunctions.map(value => value),
        nextToken.map(value => value)
      )
    def lambdaFunctions: Option[List[FunctionArn]]
    def nextToken: Option[NextToken]
    def getLambdaFunctions: ZIO[Any, AwsError, List[FunctionArn]] =
      AwsError.unwrapOptionField("lambdaFunctions", lambdaFunctions)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connect.model.ListLambdaFunctionsResponse
  ) extends zio.aws.connect.model.ListLambdaFunctionsResponse.ReadOnly {
    override val lambdaFunctions: Option[List[FunctionArn]] = scala
      .Option(impl.lambdaFunctions())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.connect.model.primitives.FunctionArn(item)
        }.toList
      )
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.connect.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.connect.model.ListLambdaFunctionsResponse
  ): zio.aws.connect.model.ListLambdaFunctionsResponse.ReadOnly = new Wrapper(
    impl
  )
}
