package zio.aws.connect.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.connect.model.primitives.NextToken
import scala.jdk.CollectionConverters._
final case class ListPromptsResponse(
    promptSummaryList: Option[Iterable[zio.aws.connect.model.PromptSummary]] =
      None,
    nextToken: Option[NextToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connect.model.ListPromptsResponse = {
    import ListPromptsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connect.model.ListPromptsResponse
      .builder()
      .optionallyWith(
        promptSummaryList.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.promptSummaryList)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.connect.model.ListPromptsResponse.ReadOnly =
    zio.aws.connect.model.ListPromptsResponse.wrap(buildAwsValue())
}
object ListPromptsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connect.model.ListPromptsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connect.model.ListPromptsResponse =
      zio.aws.connect.model.ListPromptsResponse(
        promptSummaryList.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def promptSummaryList
        : Option[List[zio.aws.connect.model.PromptSummary.ReadOnly]]
    def nextToken: Option[NextToken]
    def getPromptSummaryList: ZIO[Any, AwsError, List[
      zio.aws.connect.model.PromptSummary.ReadOnly
    ]] = AwsError.unwrapOptionField("promptSummaryList", promptSummaryList)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connect.model.ListPromptsResponse
  ) extends zio.aws.connect.model.ListPromptsResponse.ReadOnly {
    override val promptSummaryList
        : Option[List[zio.aws.connect.model.PromptSummary.ReadOnly]] = scala
      .Option(impl.promptSummaryList())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.connect.model.PromptSummary.wrap(item)
        }.toList
      )
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.connect.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.connect.model.ListPromptsResponse
  ): zio.aws.connect.model.ListPromptsResponse.ReadOnly = new Wrapper(impl)
}
