package zio.aws.connect.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.connect.model.primitives.NextToken
import scala.jdk.CollectionConverters._
final case class ListQueueQuickConnectsResponse(
    nextToken: Option[NextToken] = None,
    quickConnectSummaryList: Option[
      Iterable[zio.aws.connect.model.QuickConnectSummary]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connect.model.ListQueueQuickConnectsResponse = {
    import ListQueueQuickConnectsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connect.model.ListQueueQuickConnectsResponse
      .builder()
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        quickConnectSummaryList.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.quickConnectSummaryList)
      .build()
  }
  def asReadOnly
      : zio.aws.connect.model.ListQueueQuickConnectsResponse.ReadOnly =
    zio.aws.connect.model.ListQueueQuickConnectsResponse.wrap(buildAwsValue())
}
object ListQueueQuickConnectsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connect.model.ListQueueQuickConnectsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connect.model.ListQueueQuickConnectsResponse =
      zio.aws.connect.model.ListQueueQuickConnectsResponse(
        nextToken.map(value => value),
        quickConnectSummaryList.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def nextToken: Option[NextToken]
    def quickConnectSummaryList
        : Option[List[zio.aws.connect.model.QuickConnectSummary.ReadOnly]]
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getQuickConnectSummaryList: ZIO[Any, AwsError, List[
      zio.aws.connect.model.QuickConnectSummary.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "quickConnectSummaryList",
      quickConnectSummaryList
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connect.model.ListQueueQuickConnectsResponse
  ) extends zio.aws.connect.model.ListQueueQuickConnectsResponse.ReadOnly {
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.connect.model.primitives.NextToken(value))
    override val quickConnectSummaryList
        : Option[List[zio.aws.connect.model.QuickConnectSummary.ReadOnly]] =
      scala
        .Option(impl.quickConnectSummaryList())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.connect.model.QuickConnectSummary.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.connect.model.ListQueueQuickConnectsResponse
  ): zio.aws.connect.model.ListQueueQuickConnectsResponse.ReadOnly =
    new Wrapper(impl)
}
