package zio.aws.connect.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.connect.model.primitives.{MaxResult1000, NextToken, InstanceId}
import scala.jdk.CollectionConverters._
final case class ListQueuesRequest(
    instanceId: InstanceId,
    queueTypes: Option[Iterable[zio.aws.connect.model.QueueType]] = None,
    nextToken: Option[NextToken] = None,
    maxResults: Option[MaxResult1000] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connect.model.ListQueuesRequest = {
    import ListQueuesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connect.model.ListQueuesRequest
      .builder()
      .instanceId(InstanceId.unwrap(instanceId): java.lang.String)
      .optionallyWith(
        queueTypes.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.queueTypesWithStrings)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value => MaxResult1000.unwrap(value): Integer)
      )(_.maxResults)
      .build()
  }
  def asReadOnly: zio.aws.connect.model.ListQueuesRequest.ReadOnly =
    zio.aws.connect.model.ListQueuesRequest.wrap(buildAwsValue())
}
object ListQueuesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connect.model.ListQueuesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connect.model.ListQueuesRequest =
      zio.aws.connect.model.ListQueuesRequest(
        instanceId,
        queueTypes.map(value => value),
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def instanceId: InstanceId
    def queueTypes: Option[List[zio.aws.connect.model.QueueType]]
    def nextToken: Option[NextToken]
    def maxResults: Option[MaxResult1000]
    def getInstanceId: ZIO[Any, Nothing, InstanceId] = ZIO.succeed(instanceId)
    def getQueueTypes
        : ZIO[Any, AwsError, List[zio.aws.connect.model.QueueType]] =
      AwsError.unwrapOptionField("queueTypes", queueTypes)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, MaxResult1000] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connect.model.ListQueuesRequest
  ) extends zio.aws.connect.model.ListQueuesRequest.ReadOnly {
    override val instanceId: InstanceId =
      zio.aws.connect.model.primitives.InstanceId(impl.instanceId())
    override val queueTypes: Option[List[zio.aws.connect.model.QueueType]] =
      scala
        .Option(impl.queueTypes())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.connect.model.QueueType.wrap(item)
          }.toList
        )
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.connect.model.primitives.NextToken(value))
    override val maxResults: Option[MaxResult1000] = scala
      .Option(impl.maxResults())
      .map(value => zio.aws.connect.model.primitives.MaxResult1000(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.connect.model.ListQueuesRequest
  ): zio.aws.connect.model.ListQueuesRequest.ReadOnly = new Wrapper(impl)
}
