package zio.aws.connect.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.connect.model.primitives.{
  MaxResult100,
  NextToken,
  RoutingProfileId,
  InstanceId
}
import scala.jdk.CollectionConverters._
final case class ListRoutingProfileQueuesRequest(
    instanceId: InstanceId,
    routingProfileId: RoutingProfileId,
    nextToken: Option[NextToken] = None,
    maxResults: Option[MaxResult100] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connect.model.ListRoutingProfileQueuesRequest = {
    import ListRoutingProfileQueuesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connect.model.ListRoutingProfileQueuesRequest
      .builder()
      .instanceId(InstanceId.unwrap(instanceId): java.lang.String)
      .routingProfileId(
        RoutingProfileId.unwrap(routingProfileId): java.lang.String
      )
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value => MaxResult100.unwrap(value): Integer)
      )(_.maxResults)
      .build()
  }
  def asReadOnly
      : zio.aws.connect.model.ListRoutingProfileQueuesRequest.ReadOnly =
    zio.aws.connect.model.ListRoutingProfileQueuesRequest.wrap(buildAwsValue())
}
object ListRoutingProfileQueuesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connect.model.ListRoutingProfileQueuesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connect.model.ListRoutingProfileQueuesRequest =
      zio.aws.connect.model.ListRoutingProfileQueuesRequest(
        instanceId,
        routingProfileId,
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def instanceId: InstanceId
    def routingProfileId: RoutingProfileId
    def nextToken: Option[NextToken]
    def maxResults: Option[MaxResult100]
    def getInstanceId: ZIO[Any, Nothing, InstanceId] = ZIO.succeed(instanceId)
    def getRoutingProfileId: ZIO[Any, Nothing, RoutingProfileId] =
      ZIO.succeed(routingProfileId)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, MaxResult100] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connect.model.ListRoutingProfileQueuesRequest
  ) extends zio.aws.connect.model.ListRoutingProfileQueuesRequest.ReadOnly {
    override val instanceId: InstanceId =
      zio.aws.connect.model.primitives.InstanceId(impl.instanceId())
    override val routingProfileId: RoutingProfileId =
      zio.aws.connect.model.primitives.RoutingProfileId(impl.routingProfileId())
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.connect.model.primitives.NextToken(value))
    override val maxResults: Option[MaxResult100] = scala
      .Option(impl.maxResults())
      .map(value => zio.aws.connect.model.primitives.MaxResult100(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.connect.model.ListRoutingProfileQueuesRequest
  ): zio.aws.connect.model.ListRoutingProfileQueuesRequest.ReadOnly =
    new Wrapper(impl)
}
