package zio.aws.connect.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.connect.model.primitives.NextToken
import scala.jdk.CollectionConverters._
final case class ListRoutingProfileQueuesResponse(
    nextToken: Option[NextToken] = None,
    routingProfileQueueConfigSummaryList: Option[
      Iterable[zio.aws.connect.model.RoutingProfileQueueConfigSummary]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connect.model.ListRoutingProfileQueuesResponse = {
    import ListRoutingProfileQueuesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connect.model.ListRoutingProfileQueuesResponse
      .builder()
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        routingProfileQueueConfigSummaryList.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.routingProfileQueueConfigSummaryList)
      .build()
  }
  def asReadOnly
      : zio.aws.connect.model.ListRoutingProfileQueuesResponse.ReadOnly =
    zio.aws.connect.model.ListRoutingProfileQueuesResponse.wrap(buildAwsValue())
}
object ListRoutingProfileQueuesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connect.model.ListRoutingProfileQueuesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connect.model.ListRoutingProfileQueuesResponse =
      zio.aws.connect.model.ListRoutingProfileQueuesResponse(
        nextToken.map(value => value),
        routingProfileQueueConfigSummaryList.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def nextToken: Option[NextToken]
    def routingProfileQueueConfigSummaryList: Option[
      List[zio.aws.connect.model.RoutingProfileQueueConfigSummary.ReadOnly]
    ]
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getRoutingProfileQueueConfigSummaryList: ZIO[Any, AwsError, List[
      zio.aws.connect.model.RoutingProfileQueueConfigSummary.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "routingProfileQueueConfigSummaryList",
      routingProfileQueueConfigSummaryList
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connect.model.ListRoutingProfileQueuesResponse
  ) extends zio.aws.connect.model.ListRoutingProfileQueuesResponse.ReadOnly {
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.connect.model.primitives.NextToken(value))
    override val routingProfileQueueConfigSummaryList: Option[
      List[zio.aws.connect.model.RoutingProfileQueueConfigSummary.ReadOnly]
    ] = scala
      .Option(impl.routingProfileQueueConfigSummaryList())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.connect.model.RoutingProfileQueueConfigSummary.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.connect.model.ListRoutingProfileQueuesResponse
  ): zio.aws.connect.model.ListRoutingProfileQueuesResponse.ReadOnly =
    new Wrapper(impl)
}
