package zio.aws.connect.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.connect.model.primitives.{MaxResult2, NextToken, InstanceId}
import scala.jdk.CollectionConverters._
final case class ListSecurityKeysRequest(
    instanceId: InstanceId,
    nextToken: Option[NextToken] = None,
    maxResults: Option[MaxResult2] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connect.model.ListSecurityKeysRequest = {
    import ListSecurityKeysRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connect.model.ListSecurityKeysRequest
      .builder()
      .instanceId(InstanceId.unwrap(instanceId): java.lang.String)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value => MaxResult2.unwrap(value): Integer)
      )(_.maxResults)
      .build()
  }
  def asReadOnly: zio.aws.connect.model.ListSecurityKeysRequest.ReadOnly =
    zio.aws.connect.model.ListSecurityKeysRequest.wrap(buildAwsValue())
}
object ListSecurityKeysRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connect.model.ListSecurityKeysRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connect.model.ListSecurityKeysRequest =
      zio.aws.connect.model.ListSecurityKeysRequest(
        instanceId,
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def instanceId: InstanceId
    def nextToken: Option[NextToken]
    def maxResults: Option[MaxResult2]
    def getInstanceId: ZIO[Any, Nothing, InstanceId] = ZIO.succeed(instanceId)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, MaxResult2] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connect.model.ListSecurityKeysRequest
  ) extends zio.aws.connect.model.ListSecurityKeysRequest.ReadOnly {
    override val instanceId: InstanceId =
      zio.aws.connect.model.primitives.InstanceId(impl.instanceId())
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.connect.model.primitives.NextToken(value))
    override val maxResults: Option[MaxResult2] = scala
      .Option(impl.maxResults())
      .map(value => zio.aws.connect.model.primitives.MaxResult2(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.connect.model.ListSecurityKeysRequest
  ): zio.aws.connect.model.ListSecurityKeysRequest.ReadOnly = new Wrapper(impl)
}
