package zio.aws.connect.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.connect.model.primitives.NextToken
import scala.jdk.CollectionConverters._
final case class ListSecurityKeysResponse(
    securityKeys: Option[Iterable[zio.aws.connect.model.SecurityKey]] = None,
    nextToken: Option[NextToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connect.model.ListSecurityKeysResponse = {
    import ListSecurityKeysResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connect.model.ListSecurityKeysResponse
      .builder()
      .optionallyWith(
        securityKeys.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.securityKeys)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.connect.model.ListSecurityKeysResponse.ReadOnly =
    zio.aws.connect.model.ListSecurityKeysResponse.wrap(buildAwsValue())
}
object ListSecurityKeysResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connect.model.ListSecurityKeysResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connect.model.ListSecurityKeysResponse =
      zio.aws.connect.model.ListSecurityKeysResponse(
        securityKeys.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def securityKeys: Option[List[zio.aws.connect.model.SecurityKey.ReadOnly]]
    def nextToken: Option[NextToken]
    def getSecurityKeys
        : ZIO[Any, AwsError, List[zio.aws.connect.model.SecurityKey.ReadOnly]] =
      AwsError.unwrapOptionField("securityKeys", securityKeys)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connect.model.ListSecurityKeysResponse
  ) extends zio.aws.connect.model.ListSecurityKeysResponse.ReadOnly {
    override val securityKeys
        : Option[List[zio.aws.connect.model.SecurityKey.ReadOnly]] = scala
      .Option(impl.securityKeys())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.connect.model.SecurityKey.wrap(item)
        }.toList
      )
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.connect.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.connect.model.ListSecurityKeysResponse
  ): zio.aws.connect.model.ListSecurityKeysResponse.ReadOnly = new Wrapper(impl)
}
