package zio.aws.connect.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.connect.model.primitives.{NextToken, SecurityProfilePermission}
import scala.jdk.CollectionConverters._
final case class ListSecurityProfilePermissionsResponse(
    permissions: Option[Iterable[SecurityProfilePermission]] = None,
    nextToken: Option[NextToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connect.model.ListSecurityProfilePermissionsResponse = {
    import ListSecurityProfilePermissionsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connect.model.ListSecurityProfilePermissionsResponse
      .builder()
      .optionallyWith(
        permissions.map(value =>
          value.map { item =>
            SecurityProfilePermission.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.permissions)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.connect.model.ListSecurityProfilePermissionsResponse.ReadOnly =
    zio.aws.connect.model.ListSecurityProfilePermissionsResponse
      .wrap(buildAwsValue())
}
object ListSecurityProfilePermissionsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connect.model.ListSecurityProfilePermissionsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.connect.model.ListSecurityProfilePermissionsResponse =
      zio.aws.connect.model.ListSecurityProfilePermissionsResponse(
        permissions.map(value => value),
        nextToken.map(value => value)
      )
    def permissions: Option[List[SecurityProfilePermission]]
    def nextToken: Option[NextToken]
    def getPermissions: ZIO[Any, AwsError, List[SecurityProfilePermission]] =
      AwsError.unwrapOptionField("permissions", permissions)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connect.model.ListSecurityProfilePermissionsResponse
  ) extends zio.aws.connect.model.ListSecurityProfilePermissionsResponse.ReadOnly {
    override val permissions: Option[List[SecurityProfilePermission]] = scala
      .Option(impl.permissions())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.connect.model.primitives.SecurityProfilePermission(item)
        }.toList
      )
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.connect.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.connect.model.ListSecurityProfilePermissionsResponse
  ): zio.aws.connect.model.ListSecurityProfilePermissionsResponse.ReadOnly =
    new Wrapper(impl)
}
