package zio.aws.connect.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.connect.model.primitives.{
  ContactFlowId,
  PhoneNumberId,
  OutboundCallerIdName
}
import scala.jdk.CollectionConverters._
final case class OutboundCallerConfig(
    outboundCallerIdName: Option[OutboundCallerIdName] = None,
    outboundCallerIdNumberId: Option[PhoneNumberId] = None,
    outboundFlowId: Option[ContactFlowId] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connect.model.OutboundCallerConfig = {
    import OutboundCallerConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connect.model.OutboundCallerConfig
      .builder()
      .optionallyWith(
        outboundCallerIdName.map(value =>
          OutboundCallerIdName.unwrap(value): java.lang.String
        )
      )(_.outboundCallerIdName)
      .optionallyWith(
        outboundCallerIdNumberId.map(value =>
          PhoneNumberId.unwrap(value): java.lang.String
        )
      )(_.outboundCallerIdNumberId)
      .optionallyWith(
        outboundFlowId.map(value =>
          ContactFlowId.unwrap(value): java.lang.String
        )
      )(_.outboundFlowId)
      .build()
  }
  def asReadOnly: zio.aws.connect.model.OutboundCallerConfig.ReadOnly =
    zio.aws.connect.model.OutboundCallerConfig.wrap(buildAwsValue())
}
object OutboundCallerConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connect.model.OutboundCallerConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connect.model.OutboundCallerConfig =
      zio.aws.connect.model.OutboundCallerConfig(
        outboundCallerIdName.map(value => value),
        outboundCallerIdNumberId.map(value => value),
        outboundFlowId.map(value => value)
      )
    def outboundCallerIdName: Option[OutboundCallerIdName]
    def outboundCallerIdNumberId: Option[PhoneNumberId]
    def outboundFlowId: Option[ContactFlowId]
    def getOutboundCallerIdName: ZIO[Any, AwsError, OutboundCallerIdName] =
      AwsError.unwrapOptionField("outboundCallerIdName", outboundCallerIdName)
    def getOutboundCallerIdNumberId: ZIO[Any, AwsError, PhoneNumberId] =
      AwsError.unwrapOptionField(
        "outboundCallerIdNumberId",
        outboundCallerIdNumberId
      )
    def getOutboundFlowId: ZIO[Any, AwsError, ContactFlowId] =
      AwsError.unwrapOptionField("outboundFlowId", outboundFlowId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connect.model.OutboundCallerConfig
  ) extends zio.aws.connect.model.OutboundCallerConfig.ReadOnly {
    override val outboundCallerIdName: Option[OutboundCallerIdName] = scala
      .Option(impl.outboundCallerIdName())
      .map(value =>
        zio.aws.connect.model.primitives.OutboundCallerIdName(value)
      )
    override val outboundCallerIdNumberId: Option[PhoneNumberId] = scala
      .Option(impl.outboundCallerIdNumberId())
      .map(value => zio.aws.connect.model.primitives.PhoneNumberId(value))
    override val outboundFlowId: Option[ContactFlowId] = scala
      .Option(impl.outboundFlowId())
      .map(value => zio.aws.connect.model.primitives.ContactFlowId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.connect.model.OutboundCallerConfig
  ): zio.aws.connect.model.OutboundCallerConfig.ReadOnly = new Wrapper(impl)
}
