package zio.aws.connect.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.connect.model.primitives.{PhoneNumber, ARN, PhoneNumberId}
import scala.jdk.CollectionConverters._
final case class PhoneNumberSummary(
    id: Option[PhoneNumberId] = None,
    arn: Option[ARN] = None,
    phoneNumber: Option[PhoneNumber] = None,
    phoneNumberType: Option[zio.aws.connect.model.PhoneNumberType] = None,
    phoneNumberCountryCode: Option[
      zio.aws.connect.model.PhoneNumberCountryCode
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connect.model.PhoneNumberSummary = {
    import PhoneNumberSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connect.model.PhoneNumberSummary
      .builder()
      .optionallyWith(
        id.map(value => PhoneNumberId.unwrap(value): java.lang.String)
      )(_.id)
      .optionallyWith(arn.map(value => ARN.unwrap(value): java.lang.String))(
        _.arn
      )
      .optionallyWith(
        phoneNumber.map(value => PhoneNumber.unwrap(value): java.lang.String)
      )(_.phoneNumber)
      .optionallyWith(phoneNumberType.map(value => value.unwrap))(
        _.phoneNumberType
      )
      .optionallyWith(phoneNumberCountryCode.map(value => value.unwrap))(
        _.phoneNumberCountryCode
      )
      .build()
  }
  def asReadOnly: zio.aws.connect.model.PhoneNumberSummary.ReadOnly =
    zio.aws.connect.model.PhoneNumberSummary.wrap(buildAwsValue())
}
object PhoneNumberSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connect.model.PhoneNumberSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connect.model.PhoneNumberSummary =
      zio.aws.connect.model.PhoneNumberSummary(
        id.map(value => value),
        arn.map(value => value),
        phoneNumber.map(value => value),
        phoneNumberType.map(value => value),
        phoneNumberCountryCode.map(value => value)
      )
    def id: Option[PhoneNumberId]
    def arn: Option[ARN]
    def phoneNumber: Option[PhoneNumber]
    def phoneNumberType: Option[zio.aws.connect.model.PhoneNumberType]
    def phoneNumberCountryCode
        : Option[zio.aws.connect.model.PhoneNumberCountryCode]
    def getId: ZIO[Any, AwsError, PhoneNumberId] =
      AwsError.unwrapOptionField("id", id)
    def getArn: ZIO[Any, AwsError, ARN] = AwsError.unwrapOptionField("arn", arn)
    def getPhoneNumber: ZIO[Any, AwsError, PhoneNumber] =
      AwsError.unwrapOptionField("phoneNumber", phoneNumber)
    def getPhoneNumberType
        : ZIO[Any, AwsError, zio.aws.connect.model.PhoneNumberType] =
      AwsError.unwrapOptionField("phoneNumberType", phoneNumberType)
    def getPhoneNumberCountryCode
        : ZIO[Any, AwsError, zio.aws.connect.model.PhoneNumberCountryCode] =
      AwsError.unwrapOptionField(
        "phoneNumberCountryCode",
        phoneNumberCountryCode
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connect.model.PhoneNumberSummary
  ) extends zio.aws.connect.model.PhoneNumberSummary.ReadOnly {
    override val id: Option[PhoneNumberId] = scala
      .Option(impl.id())
      .map(value => zio.aws.connect.model.primitives.PhoneNumberId(value))
    override val arn: Option[ARN] = scala
      .Option(impl.arn())
      .map(value => zio.aws.connect.model.primitives.ARN(value))
    override val phoneNumber: Option[PhoneNumber] = scala
      .Option(impl.phoneNumber())
      .map(value => zio.aws.connect.model.primitives.PhoneNumber(value))
    override val phoneNumberType
        : Option[zio.aws.connect.model.PhoneNumberType] = scala
      .Option(impl.phoneNumberType())
      .map(value => zio.aws.connect.model.PhoneNumberType.wrap(value))
    override val phoneNumberCountryCode
        : Option[zio.aws.connect.model.PhoneNumberCountryCode] = scala
      .Option(impl.phoneNumberCountryCode())
      .map(value => zio.aws.connect.model.PhoneNumberCountryCode.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.connect.model.PhoneNumberSummary
  ): zio.aws.connect.model.PhoneNumberSummary.ReadOnly = new Wrapper(impl)
}
