package zio.aws.connect.model
import scala.jdk.CollectionConverters._
sealed trait PhoneNumberType {
  def unwrap: software.amazon.awssdk.services.connect.model.PhoneNumberType
}
object PhoneNumberType {
  def wrap(
      value: software.amazon.awssdk.services.connect.model.PhoneNumberType
  ): zio.aws.connect.model.PhoneNumberType = value match {
    case software.amazon.awssdk.services.connect.model.PhoneNumberType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.connect.model.PhoneNumberType.TOLL_FREE =>
      val r = TOLL_FREE
      r
    case software.amazon.awssdk.services.connect.model.PhoneNumberType.DID =>
      val r = DID
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.connect.model.PhoneNumberType {
    override def unwrap
        : software.amazon.awssdk.services.connect.model.PhoneNumberType =
      software.amazon.awssdk.services.connect.model.PhoneNumberType.UNKNOWN_TO_SDK_VERSION
  }
  case object TOLL_FREE extends zio.aws.connect.model.PhoneNumberType {
    override def unwrap
        : software.amazon.awssdk.services.connect.model.PhoneNumberType =
      software.amazon.awssdk.services.connect.model.PhoneNumberType.TOLL_FREE
  }
  case object DID extends zio.aws.connect.model.PhoneNumberType {
    override def unwrap
        : software.amazon.awssdk.services.connect.model.PhoneNumberType =
      software.amazon.awssdk.services.connect.model.PhoneNumberType.DID
  }
}
