package zio.aws.connect.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.connect.model.primitives.{PromptName, ARN, PromptId}
import scala.jdk.CollectionConverters._
final case class PromptSummary(
    id: Option[PromptId] = None,
    arn: Option[ARN] = None,
    name: Option[PromptName] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connect.model.PromptSummary = {
    import PromptSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connect.model.PromptSummary
      .builder()
      .optionallyWith(
        id.map(value => PromptId.unwrap(value): java.lang.String)
      )(_.id)
      .optionallyWith(arn.map(value => ARN.unwrap(value): java.lang.String))(
        _.arn
      )
      .optionallyWith(
        name.map(value => PromptName.unwrap(value): java.lang.String)
      )(_.name)
      .build()
  }
  def asReadOnly: zio.aws.connect.model.PromptSummary.ReadOnly =
    zio.aws.connect.model.PromptSummary.wrap(buildAwsValue())
}
object PromptSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connect.model.PromptSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connect.model.PromptSummary =
      zio.aws.connect.model.PromptSummary(
        id.map(value => value),
        arn.map(value => value),
        name.map(value => value)
      )
    def id: Option[PromptId]
    def arn: Option[ARN]
    def name: Option[PromptName]
    def getId: ZIO[Any, AwsError, PromptId] =
      AwsError.unwrapOptionField("id", id)
    def getArn: ZIO[Any, AwsError, ARN] = AwsError.unwrapOptionField("arn", arn)
    def getName: ZIO[Any, AwsError, PromptName] =
      AwsError.unwrapOptionField("name", name)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connect.model.PromptSummary
  ) extends zio.aws.connect.model.PromptSummary.ReadOnly {
    override val id: Option[PromptId] = scala
      .Option(impl.id())
      .map(value => zio.aws.connect.model.primitives.PromptId(value))
    override val arn: Option[ARN] = scala
      .Option(impl.arn())
      .map(value => zio.aws.connect.model.primitives.ARN(value))
    override val name: Option[PromptName] = scala
      .Option(impl.name())
      .map(value => zio.aws.connect.model.primitives.PromptName(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.connect.model.PromptSummary
  ): zio.aws.connect.model.PromptSummary.ReadOnly = new Wrapper(impl)
}
