package zio.aws.connect.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.connect.model.primitives.{
  QueueId,
  HoursOfOperationId,
  TagValue,
  QueueMaxContacts,
  CommonNameLength127,
  QueueDescription,
  ARN,
  TagKey
}
import scala.jdk.CollectionConverters._
final case class Queue(
    name: Option[CommonNameLength127] = None,
    queueArn: Option[ARN] = None,
    queueId: Option[QueueId] = None,
    description: Option[QueueDescription] = None,
    outboundCallerConfig: Option[zio.aws.connect.model.OutboundCallerConfig] =
      None,
    hoursOfOperationId: Option[HoursOfOperationId] = None,
    maxContacts: Option[QueueMaxContacts] = None,
    status: Option[zio.aws.connect.model.QueueStatus] = None,
    tags: Option[Map[TagKey, TagValue]] = None
) {
  def buildAwsValue(): software.amazon.awssdk.services.connect.model.Queue = {
    import Queue.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connect.model.Queue
      .builder()
      .optionallyWith(
        name.map(value => CommonNameLength127.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        queueArn.map(value => ARN.unwrap(value): java.lang.String)
      )(_.queueArn)
      .optionallyWith(
        queueId.map(value => QueueId.unwrap(value): java.lang.String)
      )(_.queueId)
      .optionallyWith(
        description.map(value =>
          QueueDescription.unwrap(value): java.lang.String
        )
      )(_.description)
      .optionallyWith(outboundCallerConfig.map(value => value.buildAwsValue()))(
        _.outboundCallerConfig
      )
      .optionallyWith(
        hoursOfOperationId.map(value =>
          HoursOfOperationId.unwrap(value): java.lang.String
        )
      )(_.hoursOfOperationId)
      .optionallyWith(
        maxContacts.map(value => QueueMaxContacts.unwrap(value): Integer)
      )(_.maxContacts)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.connect.model.Queue.ReadOnly =
    zio.aws.connect.model.Queue.wrap(buildAwsValue())
}
object Queue {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.connect.model.Queue] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connect.model.Queue = zio.aws.connect.model.Queue(
      name.map(value => value),
      queueArn.map(value => value),
      queueId.map(value => value),
      description.map(value => value),
      outboundCallerConfig.map(value => value.asEditable),
      hoursOfOperationId.map(value => value),
      maxContacts.map(value => value),
      status.map(value => value),
      tags.map(value => value)
    )
    def name: Option[CommonNameLength127]
    def queueArn: Option[ARN]
    def queueId: Option[QueueId]
    def description: Option[QueueDescription]
    def outboundCallerConfig
        : Option[zio.aws.connect.model.OutboundCallerConfig.ReadOnly]
    def hoursOfOperationId: Option[HoursOfOperationId]
    def maxContacts: Option[QueueMaxContacts]
    def status: Option[zio.aws.connect.model.QueueStatus]
    def tags: Option[Map[TagKey, TagValue]]
    def getName: ZIO[Any, AwsError, CommonNameLength127] =
      AwsError.unwrapOptionField("name", name)
    def getQueueArn: ZIO[Any, AwsError, ARN] =
      AwsError.unwrapOptionField("queueArn", queueArn)
    def getQueueId: ZIO[Any, AwsError, QueueId] =
      AwsError.unwrapOptionField("queueId", queueId)
    def getDescription: ZIO[Any, AwsError, QueueDescription] =
      AwsError.unwrapOptionField("description", description)
    def getOutboundCallerConfig: ZIO[
      Any,
      AwsError,
      zio.aws.connect.model.OutboundCallerConfig.ReadOnly
    ] = AwsError.unwrapOptionField("outboundCallerConfig", outboundCallerConfig)
    def getHoursOfOperationId: ZIO[Any, AwsError, HoursOfOperationId] =
      AwsError.unwrapOptionField("hoursOfOperationId", hoursOfOperationId)
    def getMaxContacts: ZIO[Any, AwsError, QueueMaxContacts] =
      AwsError.unwrapOptionField("maxContacts", maxContacts)
    def getStatus: ZIO[Any, AwsError, zio.aws.connect.model.QueueStatus] =
      AwsError.unwrapOptionField("status", status)
    def getTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connect.model.Queue
  ) extends zio.aws.connect.model.Queue.ReadOnly {
    override val name: Option[CommonNameLength127] = scala
      .Option(impl.name())
      .map(value => zio.aws.connect.model.primitives.CommonNameLength127(value))
    override val queueArn: Option[ARN] = scala
      .Option(impl.queueArn())
      .map(value => zio.aws.connect.model.primitives.ARN(value))
    override val queueId: Option[QueueId] = scala
      .Option(impl.queueId())
      .map(value => zio.aws.connect.model.primitives.QueueId(value))
    override val description: Option[QueueDescription] = scala
      .Option(impl.description())
      .map(value => zio.aws.connect.model.primitives.QueueDescription(value))
    override val outboundCallerConfig
        : Option[zio.aws.connect.model.OutboundCallerConfig.ReadOnly] = scala
      .Option(impl.outboundCallerConfig())
      .map(value => zio.aws.connect.model.OutboundCallerConfig.wrap(value))
    override val hoursOfOperationId: Option[HoursOfOperationId] = scala
      .Option(impl.hoursOfOperationId())
      .map(value => zio.aws.connect.model.primitives.HoursOfOperationId(value))
    override val maxContacts: Option[QueueMaxContacts] = scala
      .Option(impl.maxContacts())
      .map(value => zio.aws.connect.model.primitives.QueueMaxContacts(value))
    override val status: Option[zio.aws.connect.model.QueueStatus] = scala
      .Option(impl.status())
      .map(value => zio.aws.connect.model.QueueStatus.wrap(value))
    override val tags: Option[Map[TagKey, TagValue]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.connect.model.primitives
              .TagKey(key) -> zio.aws.connect.model.primitives.TagValue(value)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.connect.model.Queue
  ): zio.aws.connect.model.Queue.ReadOnly = new Wrapper(impl)
}
