package zio.aws.connect.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import zio.aws.connect.model.primitives.{Timestamp, QueueId}
import scala.jdk.CollectionConverters._
final case class QueueInfo(
    id: Option[QueueId] = None,
    enqueueTimestamp: Option[Timestamp] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connect.model.QueueInfo = {
    import QueueInfo.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connect.model.QueueInfo
      .builder()
      .optionallyWith(id.map(value => QueueId.unwrap(value): java.lang.String))(
        _.id
      )
      .optionallyWith(
        enqueueTimestamp.map(value => Timestamp.unwrap(value): Instant)
      )(_.enqueueTimestamp)
      .build()
  }
  def asReadOnly: zio.aws.connect.model.QueueInfo.ReadOnly =
    zio.aws.connect.model.QueueInfo.wrap(buildAwsValue())
}
object QueueInfo {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.connect.model.QueueInfo] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connect.model.QueueInfo = zio.aws.connect.model
      .QueueInfo(id.map(value => value), enqueueTimestamp.map(value => value))
    def id: Option[QueueId]
    def enqueueTimestamp: Option[Timestamp]
    def getId: ZIO[Any, AwsError, QueueId] =
      AwsError.unwrapOptionField("id", id)
    def getEnqueueTimestamp: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("enqueueTimestamp", enqueueTimestamp)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connect.model.QueueInfo
  ) extends zio.aws.connect.model.QueueInfo.ReadOnly {
    override val id: Option[QueueId] = scala
      .Option(impl.id())
      .map(value => zio.aws.connect.model.primitives.QueueId(value))
    override val enqueueTimestamp: Option[Timestamp] = scala
      .Option(impl.enqueueTimestamp())
      .map(value => zio.aws.connect.model.primitives.Timestamp(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.connect.model.QueueInfo
  ): zio.aws.connect.model.QueueInfo.ReadOnly = new Wrapper(impl)
}
