package zio.aws.connect.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.connect.model.primitives.{ContactFlowId, QueueId}
import scala.jdk.CollectionConverters._
final case class QueueQuickConnectConfig(
    queueId: QueueId,
    contactFlowId: ContactFlowId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connect.model.QueueQuickConnectConfig = {
    import QueueQuickConnectConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connect.model.QueueQuickConnectConfig
      .builder()
      .queueId(QueueId.unwrap(queueId): java.lang.String)
      .contactFlowId(ContactFlowId.unwrap(contactFlowId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.connect.model.QueueQuickConnectConfig.ReadOnly =
    zio.aws.connect.model.QueueQuickConnectConfig.wrap(buildAwsValue())
}
object QueueQuickConnectConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connect.model.QueueQuickConnectConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connect.model.QueueQuickConnectConfig =
      zio.aws.connect.model.QueueQuickConnectConfig(queueId, contactFlowId)
    def queueId: QueueId
    def contactFlowId: ContactFlowId
    def getQueueId: ZIO[Any, Nothing, QueueId] = ZIO.succeed(queueId)
    def getContactFlowId: ZIO[Any, Nothing, ContactFlowId] =
      ZIO.succeed(contactFlowId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connect.model.QueueQuickConnectConfig
  ) extends zio.aws.connect.model.QueueQuickConnectConfig.ReadOnly {
    override val queueId: QueueId =
      zio.aws.connect.model.primitives.QueueId(impl.queueId())
    override val contactFlowId: ContactFlowId =
      zio.aws.connect.model.primitives.ContactFlowId(impl.contactFlowId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.connect.model.QueueQuickConnectConfig
  ): zio.aws.connect.model.QueueQuickConnectConfig.ReadOnly = new Wrapper(impl)
}
