package zio.aws.connect.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.connect.model.primitives.{ARN, QueueId}
import scala.jdk.CollectionConverters._
final case class QueueReference(
    id: Option[QueueId] = None,
    arn: Option[ARN] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connect.model.QueueReference = {
    import QueueReference.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connect.model.QueueReference
      .builder()
      .optionallyWith(id.map(value => QueueId.unwrap(value): java.lang.String))(
        _.id
      )
      .optionallyWith(arn.map(value => ARN.unwrap(value): java.lang.String))(
        _.arn
      )
      .build()
  }
  def asReadOnly: zio.aws.connect.model.QueueReference.ReadOnly =
    zio.aws.connect.model.QueueReference.wrap(buildAwsValue())
}
object QueueReference {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connect.model.QueueReference
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connect.model.QueueReference = zio.aws.connect.model
      .QueueReference(id.map(value => value), arn.map(value => value))
    def id: Option[QueueId]
    def arn: Option[ARN]
    def getId: ZIO[Any, AwsError, QueueId] =
      AwsError.unwrapOptionField("id", id)
    def getArn: ZIO[Any, AwsError, ARN] = AwsError.unwrapOptionField("arn", arn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connect.model.QueueReference
  ) extends zio.aws.connect.model.QueueReference.ReadOnly {
    override val id: Option[QueueId] = scala
      .Option(impl.id())
      .map(value => zio.aws.connect.model.primitives.QueueId(value))
    override val arn: Option[ARN] = scala
      .Option(impl.arn())
      .map(value => zio.aws.connect.model.primitives.ARN(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.connect.model.QueueReference
  ): zio.aws.connect.model.QueueReference.ReadOnly = new Wrapper(impl)
}
