package zio.aws.connect.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.connect.model.primitives.{
  QuickConnectId,
  TagValue,
  QuickConnectName,
  QuickConnectDescription,
  ARN,
  TagKey
}
import scala.jdk.CollectionConverters._
final case class QuickConnect(
    quickConnectARN: Option[ARN] = None,
    quickConnectId: Option[QuickConnectId] = None,
    name: Option[QuickConnectName] = None,
    description: Option[QuickConnectDescription] = None,
    quickConnectConfig: Option[zio.aws.connect.model.QuickConnectConfig] = None,
    tags: Option[Map[TagKey, TagValue]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connect.model.QuickConnect = {
    import QuickConnect.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connect.model.QuickConnect
      .builder()
      .optionallyWith(
        quickConnectARN.map(value => ARN.unwrap(value): java.lang.String)
      )(_.quickConnectARN)
      .optionallyWith(
        quickConnectId.map(value =>
          QuickConnectId.unwrap(value): java.lang.String
        )
      )(_.quickConnectId)
      .optionallyWith(
        name.map(value => QuickConnectName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        description.map(value =>
          QuickConnectDescription.unwrap(value): java.lang.String
        )
      )(_.description)
      .optionallyWith(quickConnectConfig.map(value => value.buildAwsValue()))(
        _.quickConnectConfig
      )
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.connect.model.QuickConnect.ReadOnly =
    zio.aws.connect.model.QuickConnect.wrap(buildAwsValue())
}
object QuickConnect {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connect.model.QuickConnect
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connect.model.QuickConnect =
      zio.aws.connect.model.QuickConnect(
        quickConnectARN.map(value => value),
        quickConnectId.map(value => value),
        name.map(value => value),
        description.map(value => value),
        quickConnectConfig.map(value => value.asEditable),
        tags.map(value => value)
      )
    def quickConnectARN: Option[ARN]
    def quickConnectId: Option[QuickConnectId]
    def name: Option[QuickConnectName]
    def description: Option[QuickConnectDescription]
    def quickConnectConfig
        : Option[zio.aws.connect.model.QuickConnectConfig.ReadOnly]
    def tags: Option[Map[TagKey, TagValue]]
    def getQuickConnectARN: ZIO[Any, AwsError, ARN] =
      AwsError.unwrapOptionField("quickConnectARN", quickConnectARN)
    def getQuickConnectId: ZIO[Any, AwsError, QuickConnectId] =
      AwsError.unwrapOptionField("quickConnectId", quickConnectId)
    def getName: ZIO[Any, AwsError, QuickConnectName] =
      AwsError.unwrapOptionField("name", name)
    def getDescription: ZIO[Any, AwsError, QuickConnectDescription] =
      AwsError.unwrapOptionField("description", description)
    def getQuickConnectConfig: ZIO[
      Any,
      AwsError,
      zio.aws.connect.model.QuickConnectConfig.ReadOnly
    ] = AwsError.unwrapOptionField("quickConnectConfig", quickConnectConfig)
    def getTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connect.model.QuickConnect
  ) extends zio.aws.connect.model.QuickConnect.ReadOnly {
    override val quickConnectARN: Option[ARN] = scala
      .Option(impl.quickConnectARN())
      .map(value => zio.aws.connect.model.primitives.ARN(value))
    override val quickConnectId: Option[QuickConnectId] = scala
      .Option(impl.quickConnectId())
      .map(value => zio.aws.connect.model.primitives.QuickConnectId(value))
    override val name: Option[QuickConnectName] = scala
      .Option(impl.name())
      .map(value => zio.aws.connect.model.primitives.QuickConnectName(value))
    override val description: Option[QuickConnectDescription] = scala
      .Option(impl.description())
      .map(value =>
        zio.aws.connect.model.primitives.QuickConnectDescription(value)
      )
    override val quickConnectConfig
        : Option[zio.aws.connect.model.QuickConnectConfig.ReadOnly] = scala
      .Option(impl.quickConnectConfig())
      .map(value => zio.aws.connect.model.QuickConnectConfig.wrap(value))
    override val tags: Option[Map[TagKey, TagValue]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.connect.model.primitives
              .TagKey(key) -> zio.aws.connect.model.primitives.TagValue(value)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.connect.model.QuickConnect
  ): zio.aws.connect.model.QuickConnect.ReadOnly = new Wrapper(impl)
}
