package zio.aws.connect.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class QuickConnectConfig(
    quickConnectType: zio.aws.connect.model.QuickConnectType,
    userConfig: Option[zio.aws.connect.model.UserQuickConnectConfig] = None,
    queueConfig: Option[zio.aws.connect.model.QueueQuickConnectConfig] = None,
    phoneConfig: Option[zio.aws.connect.model.PhoneNumberQuickConnectConfig] =
      None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connect.model.QuickConnectConfig = {
    import QuickConnectConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connect.model.QuickConnectConfig
      .builder()
      .quickConnectType(quickConnectType.unwrap)
      .optionallyWith(userConfig.map(value => value.buildAwsValue()))(
        _.userConfig
      )
      .optionallyWith(queueConfig.map(value => value.buildAwsValue()))(
        _.queueConfig
      )
      .optionallyWith(phoneConfig.map(value => value.buildAwsValue()))(
        _.phoneConfig
      )
      .build()
  }
  def asReadOnly: zio.aws.connect.model.QuickConnectConfig.ReadOnly =
    zio.aws.connect.model.QuickConnectConfig.wrap(buildAwsValue())
}
object QuickConnectConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connect.model.QuickConnectConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connect.model.QuickConnectConfig =
      zio.aws.connect.model.QuickConnectConfig(
        quickConnectType,
        userConfig.map(value => value.asEditable),
        queueConfig.map(value => value.asEditable),
        phoneConfig.map(value => value.asEditable)
      )
    def quickConnectType: zio.aws.connect.model.QuickConnectType
    def userConfig
        : Option[zio.aws.connect.model.UserQuickConnectConfig.ReadOnly]
    def queueConfig
        : Option[zio.aws.connect.model.QueueQuickConnectConfig.ReadOnly]
    def phoneConfig
        : Option[zio.aws.connect.model.PhoneNumberQuickConnectConfig.ReadOnly]
    def getQuickConnectType
        : ZIO[Any, Nothing, zio.aws.connect.model.QuickConnectType] =
      ZIO.succeed(quickConnectType)
    def getUserConfig: ZIO[
      Any,
      AwsError,
      zio.aws.connect.model.UserQuickConnectConfig.ReadOnly
    ] = AwsError.unwrapOptionField("userConfig", userConfig)
    def getQueueConfig: ZIO[
      Any,
      AwsError,
      zio.aws.connect.model.QueueQuickConnectConfig.ReadOnly
    ] = AwsError.unwrapOptionField("queueConfig", queueConfig)
    def getPhoneConfig: ZIO[
      Any,
      AwsError,
      zio.aws.connect.model.PhoneNumberQuickConnectConfig.ReadOnly
    ] = AwsError.unwrapOptionField("phoneConfig", phoneConfig)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connect.model.QuickConnectConfig
  ) extends zio.aws.connect.model.QuickConnectConfig.ReadOnly {
    override val quickConnectType: zio.aws.connect.model.QuickConnectType =
      zio.aws.connect.model.QuickConnectType.wrap(impl.quickConnectType())
    override val userConfig
        : Option[zio.aws.connect.model.UserQuickConnectConfig.ReadOnly] = scala
      .Option(impl.userConfig())
      .map(value => zio.aws.connect.model.UserQuickConnectConfig.wrap(value))
    override val queueConfig
        : Option[zio.aws.connect.model.QueueQuickConnectConfig.ReadOnly] = scala
      .Option(impl.queueConfig())
      .map(value => zio.aws.connect.model.QueueQuickConnectConfig.wrap(value))
    override val phoneConfig
        : Option[zio.aws.connect.model.PhoneNumberQuickConnectConfig.ReadOnly] =
      scala
        .Option(impl.phoneConfig())
        .map(value =>
          zio.aws.connect.model.PhoneNumberQuickConnectConfig.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.connect.model.QuickConnectConfig
  ): zio.aws.connect.model.QuickConnectConfig.ReadOnly = new Wrapper(impl)
}
