package zio.aws.connect.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.connect.model.primitives.{QuickConnectName, ARN, QuickConnectId}
import scala.jdk.CollectionConverters._
final case class QuickConnectSummary(
    id: Option[QuickConnectId] = None,
    arn: Option[ARN] = None,
    name: Option[QuickConnectName] = None,
    quickConnectType: Option[zio.aws.connect.model.QuickConnectType] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connect.model.QuickConnectSummary = {
    import QuickConnectSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connect.model.QuickConnectSummary
      .builder()
      .optionallyWith(
        id.map(value => QuickConnectId.unwrap(value): java.lang.String)
      )(_.id)
      .optionallyWith(arn.map(value => ARN.unwrap(value): java.lang.String))(
        _.arn
      )
      .optionallyWith(
        name.map(value => QuickConnectName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(quickConnectType.map(value => value.unwrap))(
        _.quickConnectType
      )
      .build()
  }
  def asReadOnly: zio.aws.connect.model.QuickConnectSummary.ReadOnly =
    zio.aws.connect.model.QuickConnectSummary.wrap(buildAwsValue())
}
object QuickConnectSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connect.model.QuickConnectSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connect.model.QuickConnectSummary =
      zio.aws.connect.model.QuickConnectSummary(
        id.map(value => value),
        arn.map(value => value),
        name.map(value => value),
        quickConnectType.map(value => value)
      )
    def id: Option[QuickConnectId]
    def arn: Option[ARN]
    def name: Option[QuickConnectName]
    def quickConnectType: Option[zio.aws.connect.model.QuickConnectType]
    def getId: ZIO[Any, AwsError, QuickConnectId] =
      AwsError.unwrapOptionField("id", id)
    def getArn: ZIO[Any, AwsError, ARN] = AwsError.unwrapOptionField("arn", arn)
    def getName: ZIO[Any, AwsError, QuickConnectName] =
      AwsError.unwrapOptionField("name", name)
    def getQuickConnectType
        : ZIO[Any, AwsError, zio.aws.connect.model.QuickConnectType] =
      AwsError.unwrapOptionField("quickConnectType", quickConnectType)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connect.model.QuickConnectSummary
  ) extends zio.aws.connect.model.QuickConnectSummary.ReadOnly {
    override val id: Option[QuickConnectId] = scala
      .Option(impl.id())
      .map(value => zio.aws.connect.model.primitives.QuickConnectId(value))
    override val arn: Option[ARN] = scala
      .Option(impl.arn())
      .map(value => zio.aws.connect.model.primitives.ARN(value))
    override val name: Option[QuickConnectName] = scala
      .Option(impl.name())
      .map(value => zio.aws.connect.model.primitives.QuickConnectName(value))
    override val quickConnectType
        : Option[zio.aws.connect.model.QuickConnectType] = scala
      .Option(impl.quickConnectType())
      .map(value => zio.aws.connect.model.QuickConnectType.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.connect.model.QuickConnectSummary
  ): zio.aws.connect.model.QuickConnectSummary.ReadOnly = new Wrapper(impl)
}
