package zio.aws.connect.model
import scala.jdk.CollectionConverters._
sealed trait QuickConnectType {
  def unwrap: software.amazon.awssdk.services.connect.model.QuickConnectType
}
object QuickConnectType {
  def wrap(
      value: software.amazon.awssdk.services.connect.model.QuickConnectType
  ): zio.aws.connect.model.QuickConnectType = value match {
    case software.amazon.awssdk.services.connect.model.QuickConnectType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.connect.model.QuickConnectType.USER =>
      val r = USER
      r
    case software.amazon.awssdk.services.connect.model.QuickConnectType.QUEUE =>
      val r = QUEUE
      r
    case software.amazon.awssdk.services.connect.model.QuickConnectType.PHONE_NUMBER =>
      val r = PHONE_NUMBER
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.connect.model.QuickConnectType {
    override def unwrap
        : software.amazon.awssdk.services.connect.model.QuickConnectType =
      software.amazon.awssdk.services.connect.model.QuickConnectType.UNKNOWN_TO_SDK_VERSION
  }
  case object USER extends zio.aws.connect.model.QuickConnectType {
    override def unwrap
        : software.amazon.awssdk.services.connect.model.QuickConnectType =
      software.amazon.awssdk.services.connect.model.QuickConnectType.USER
  }
  case object QUEUE extends zio.aws.connect.model.QuickConnectType {
    override def unwrap
        : software.amazon.awssdk.services.connect.model.QuickConnectType =
      software.amazon.awssdk.services.connect.model.QuickConnectType.QUEUE
  }
  case object PHONE_NUMBER extends zio.aws.connect.model.QuickConnectType {
    override def unwrap
        : software.amazon.awssdk.services.connect.model.QuickConnectType =
      software.amazon.awssdk.services.connect.model.QuickConnectType.PHONE_NUMBER
  }
}
