package zio.aws.connect.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ReferenceSummary(
    url: Option[zio.aws.connect.model.UrlReference] = None,
    attachment: Option[zio.aws.connect.model.AttachmentReference] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connect.model.ReferenceSummary = {
    import ReferenceSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connect.model.ReferenceSummary
      .builder()
      .optionallyWith(url.map(value => value.buildAwsValue()))(_.url)
      .optionallyWith(attachment.map(value => value.buildAwsValue()))(
        _.attachment
      )
      .build()
  }
  def asReadOnly: zio.aws.connect.model.ReferenceSummary.ReadOnly =
    zio.aws.connect.model.ReferenceSummary.wrap(buildAwsValue())
}
object ReferenceSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connect.model.ReferenceSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connect.model.ReferenceSummary =
      zio.aws.connect.model.ReferenceSummary(
        url.map(value => value.asEditable),
        attachment.map(value => value.asEditable)
      )
    def url: Option[zio.aws.connect.model.UrlReference.ReadOnly]
    def attachment: Option[zio.aws.connect.model.AttachmentReference.ReadOnly]
    def getUrl
        : ZIO[Any, AwsError, zio.aws.connect.model.UrlReference.ReadOnly] =
      AwsError.unwrapOptionField("url", url)
    def getAttachment: ZIO[
      Any,
      AwsError,
      zio.aws.connect.model.AttachmentReference.ReadOnly
    ] = AwsError.unwrapOptionField("attachment", attachment)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connect.model.ReferenceSummary
  ) extends zio.aws.connect.model.ReferenceSummary.ReadOnly {
    override val url: Option[zio.aws.connect.model.UrlReference.ReadOnly] =
      scala
        .Option(impl.url())
        .map(value => zio.aws.connect.model.UrlReference.wrap(value))
    override val attachment
        : Option[zio.aws.connect.model.AttachmentReference.ReadOnly] = scala
      .Option(impl.attachment())
      .map(value => zio.aws.connect.model.AttachmentReference.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.connect.model.ReferenceSummary
  ): zio.aws.connect.model.ReferenceSummary.ReadOnly = new Wrapper(impl)
}
