package zio.aws.connect.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.connect.model.primitives.{
  RoutingProfileId,
  QueueId,
  InstanceId,
  TagValue,
  RoutingProfileName,
  RoutingProfileDescription,
  ARN,
  TagKey
}
import scala.jdk.CollectionConverters._
final case class RoutingProfile(
    instanceId: Option[InstanceId] = None,
    name: Option[RoutingProfileName] = None,
    routingProfileArn: Option[ARN] = None,
    routingProfileId: Option[RoutingProfileId] = None,
    description: Option[RoutingProfileDescription] = None,
    mediaConcurrencies: Option[
      Iterable[zio.aws.connect.model.MediaConcurrency]
    ] = None,
    defaultOutboundQueueId: Option[QueueId] = None,
    tags: Option[Map[TagKey, TagValue]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connect.model.RoutingProfile = {
    import RoutingProfile.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connect.model.RoutingProfile
      .builder()
      .optionallyWith(
        instanceId.map(value => InstanceId.unwrap(value): java.lang.String)
      )(_.instanceId)
      .optionallyWith(
        name.map(value => RoutingProfileName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        routingProfileArn.map(value => ARN.unwrap(value): java.lang.String)
      )(_.routingProfileArn)
      .optionallyWith(
        routingProfileId.map(value =>
          RoutingProfileId.unwrap(value): java.lang.String
        )
      )(_.routingProfileId)
      .optionallyWith(
        description.map(value =>
          RoutingProfileDescription.unwrap(value): java.lang.String
        )
      )(_.description)
      .optionallyWith(
        mediaConcurrencies.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.mediaConcurrencies)
      .optionallyWith(
        defaultOutboundQueueId.map(value =>
          QueueId.unwrap(value): java.lang.String
        )
      )(_.defaultOutboundQueueId)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.connect.model.RoutingProfile.ReadOnly =
    zio.aws.connect.model.RoutingProfile.wrap(buildAwsValue())
}
object RoutingProfile {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connect.model.RoutingProfile
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connect.model.RoutingProfile =
      zio.aws.connect.model.RoutingProfile(
        instanceId.map(value => value),
        name.map(value => value),
        routingProfileArn.map(value => value),
        routingProfileId.map(value => value),
        description.map(value => value),
        mediaConcurrencies.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        defaultOutboundQueueId.map(value => value),
        tags.map(value => value)
      )
    def instanceId: Option[InstanceId]
    def name: Option[RoutingProfileName]
    def routingProfileArn: Option[ARN]
    def routingProfileId: Option[RoutingProfileId]
    def description: Option[RoutingProfileDescription]
    def mediaConcurrencies
        : Option[List[zio.aws.connect.model.MediaConcurrency.ReadOnly]]
    def defaultOutboundQueueId: Option[QueueId]
    def tags: Option[Map[TagKey, TagValue]]
    def getInstanceId: ZIO[Any, AwsError, InstanceId] =
      AwsError.unwrapOptionField("instanceId", instanceId)
    def getName: ZIO[Any, AwsError, RoutingProfileName] =
      AwsError.unwrapOptionField("name", name)
    def getRoutingProfileArn: ZIO[Any, AwsError, ARN] =
      AwsError.unwrapOptionField("routingProfileArn", routingProfileArn)
    def getRoutingProfileId: ZIO[Any, AwsError, RoutingProfileId] =
      AwsError.unwrapOptionField("routingProfileId", routingProfileId)
    def getDescription: ZIO[Any, AwsError, RoutingProfileDescription] =
      AwsError.unwrapOptionField("description", description)
    def getMediaConcurrencies: ZIO[Any, AwsError, List[
      zio.aws.connect.model.MediaConcurrency.ReadOnly
    ]] = AwsError.unwrapOptionField("mediaConcurrencies", mediaConcurrencies)
    def getDefaultOutboundQueueId: ZIO[Any, AwsError, QueueId] = AwsError
      .unwrapOptionField("defaultOutboundQueueId", defaultOutboundQueueId)
    def getTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connect.model.RoutingProfile
  ) extends zio.aws.connect.model.RoutingProfile.ReadOnly {
    override val instanceId: Option[InstanceId] = scala
      .Option(impl.instanceId())
      .map(value => zio.aws.connect.model.primitives.InstanceId(value))
    override val name: Option[RoutingProfileName] = scala
      .Option(impl.name())
      .map(value => zio.aws.connect.model.primitives.RoutingProfileName(value))
    override val routingProfileArn: Option[ARN] = scala
      .Option(impl.routingProfileArn())
      .map(value => zio.aws.connect.model.primitives.ARN(value))
    override val routingProfileId: Option[RoutingProfileId] = scala
      .Option(impl.routingProfileId())
      .map(value => zio.aws.connect.model.primitives.RoutingProfileId(value))
    override val description: Option[RoutingProfileDescription] = scala
      .Option(impl.description())
      .map(value =>
        zio.aws.connect.model.primitives.RoutingProfileDescription(value)
      )
    override val mediaConcurrencies
        : Option[List[zio.aws.connect.model.MediaConcurrency.ReadOnly]] = scala
      .Option(impl.mediaConcurrencies())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.connect.model.MediaConcurrency.wrap(item)
        }.toList
      )
    override val defaultOutboundQueueId: Option[QueueId] = scala
      .Option(impl.defaultOutboundQueueId())
      .map(value => zio.aws.connect.model.primitives.QueueId(value))
    override val tags: Option[Map[TagKey, TagValue]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.connect.model.primitives
              .TagKey(key) -> zio.aws.connect.model.primitives.TagValue(value)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.connect.model.RoutingProfile
  ): zio.aws.connect.model.RoutingProfile.ReadOnly = new Wrapper(impl)
}
