package zio.aws.connect.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import zio.aws.connect.model.primitives.{Timestamp, PEM, AssociationId}
import scala.jdk.CollectionConverters._
final case class SecurityKey(
    associationId: Option[AssociationId] = None,
    key: Option[PEM] = None,
    creationTime: Option[Timestamp] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connect.model.SecurityKey = {
    import SecurityKey.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connect.model.SecurityKey
      .builder()
      .optionallyWith(
        associationId.map(value =>
          AssociationId.unwrap(value): java.lang.String
        )
      )(_.associationId)
      .optionallyWith(key.map(value => PEM.unwrap(value): java.lang.String))(
        _.key
      )
      .optionallyWith(
        creationTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.creationTime)
      .build()
  }
  def asReadOnly: zio.aws.connect.model.SecurityKey.ReadOnly =
    zio.aws.connect.model.SecurityKey.wrap(buildAwsValue())
}
object SecurityKey {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connect.model.SecurityKey
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connect.model.SecurityKey =
      zio.aws.connect.model.SecurityKey(
        associationId.map(value => value),
        key.map(value => value),
        creationTime.map(value => value)
      )
    def associationId: Option[AssociationId]
    def key: Option[PEM]
    def creationTime: Option[Timestamp]
    def getAssociationId: ZIO[Any, AwsError, AssociationId] =
      AwsError.unwrapOptionField("associationId", associationId)
    def getKey: ZIO[Any, AwsError, PEM] = AwsError.unwrapOptionField("key", key)
    def getCreationTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("creationTime", creationTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connect.model.SecurityKey
  ) extends zio.aws.connect.model.SecurityKey.ReadOnly {
    override val associationId: Option[AssociationId] = scala
      .Option(impl.associationId())
      .map(value => zio.aws.connect.model.primitives.AssociationId(value))
    override val key: Option[PEM] = scala
      .Option(impl.key())
      .map(value => zio.aws.connect.model.primitives.PEM(value))
    override val creationTime: Option[Timestamp] = scala
      .Option(impl.creationTime())
      .map(value => zio.aws.connect.model.primitives.Timestamp(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.connect.model.SecurityKey
  ): zio.aws.connect.model.SecurityKey.ReadOnly = new Wrapper(impl)
}
