package zio.aws.connect.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.connect.model.primitives.{
  SecurityProfileDescription,
  InstanceId,
  TagValue,
  SecurityProfileName,
  ARN,
  TagKey,
  SecurityProfileId
}
import scala.jdk.CollectionConverters._
final case class SecurityProfile(
    id: Option[SecurityProfileId] = None,
    organizationResourceId: Option[InstanceId] = None,
    arn: Option[ARN] = None,
    securityProfileName: Option[SecurityProfileName] = None,
    description: Option[SecurityProfileDescription] = None,
    tags: Option[Map[TagKey, TagValue]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connect.model.SecurityProfile = {
    import SecurityProfile.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connect.model.SecurityProfile
      .builder()
      .optionallyWith(
        id.map(value => SecurityProfileId.unwrap(value): java.lang.String)
      )(_.id)
      .optionallyWith(
        organizationResourceId.map(value =>
          InstanceId.unwrap(value): java.lang.String
        )
      )(_.organizationResourceId)
      .optionallyWith(arn.map(value => ARN.unwrap(value): java.lang.String))(
        _.arn
      )
      .optionallyWith(
        securityProfileName.map(value =>
          SecurityProfileName.unwrap(value): java.lang.String
        )
      )(_.securityProfileName)
      .optionallyWith(
        description.map(value =>
          SecurityProfileDescription.unwrap(value): java.lang.String
        )
      )(_.description)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.connect.model.SecurityProfile.ReadOnly =
    zio.aws.connect.model.SecurityProfile.wrap(buildAwsValue())
}
object SecurityProfile {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connect.model.SecurityProfile
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connect.model.SecurityProfile =
      zio.aws.connect.model.SecurityProfile(
        id.map(value => value),
        organizationResourceId.map(value => value),
        arn.map(value => value),
        securityProfileName.map(value => value),
        description.map(value => value),
        tags.map(value => value)
      )
    def id: Option[SecurityProfileId]
    def organizationResourceId: Option[InstanceId]
    def arn: Option[ARN]
    def securityProfileName: Option[SecurityProfileName]
    def description: Option[SecurityProfileDescription]
    def tags: Option[Map[TagKey, TagValue]]
    def getId: ZIO[Any, AwsError, SecurityProfileId] =
      AwsError.unwrapOptionField("id", id)
    def getOrganizationResourceId: ZIO[Any, AwsError, InstanceId] = AwsError
      .unwrapOptionField("organizationResourceId", organizationResourceId)
    def getArn: ZIO[Any, AwsError, ARN] = AwsError.unwrapOptionField("arn", arn)
    def getSecurityProfileName: ZIO[Any, AwsError, SecurityProfileName] =
      AwsError.unwrapOptionField("securityProfileName", securityProfileName)
    def getDescription: ZIO[Any, AwsError, SecurityProfileDescription] =
      AwsError.unwrapOptionField("description", description)
    def getTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connect.model.SecurityProfile
  ) extends zio.aws.connect.model.SecurityProfile.ReadOnly {
    override val id: Option[SecurityProfileId] = scala
      .Option(impl.id())
      .map(value => zio.aws.connect.model.primitives.SecurityProfileId(value))
    override val organizationResourceId: Option[InstanceId] = scala
      .Option(impl.organizationResourceId())
      .map(value => zio.aws.connect.model.primitives.InstanceId(value))
    override val arn: Option[ARN] = scala
      .Option(impl.arn())
      .map(value => zio.aws.connect.model.primitives.ARN(value))
    override val securityProfileName: Option[SecurityProfileName] = scala
      .Option(impl.securityProfileName())
      .map(value => zio.aws.connect.model.primitives.SecurityProfileName(value))
    override val description: Option[SecurityProfileDescription] = scala
      .Option(impl.description())
      .map(value =>
        zio.aws.connect.model.primitives.SecurityProfileDescription(value)
      )
    override val tags: Option[Map[TagKey, TagValue]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.connect.model.primitives
              .TagKey(key) -> zio.aws.connect.model.primitives.TagValue(value)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.connect.model.SecurityProfile
  ): zio.aws.connect.model.SecurityProfile.ReadOnly = new Wrapper(impl)
}
