package zio.aws.connect.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.connect.model.primitives.{
  SecurityProfileName,
  ARN,
  SecurityProfileId
}
import scala.jdk.CollectionConverters._
final case class SecurityProfileSummary(
    id: Option[SecurityProfileId] = None,
    arn: Option[ARN] = None,
    name: Option[SecurityProfileName] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connect.model.SecurityProfileSummary = {
    import SecurityProfileSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connect.model.SecurityProfileSummary
      .builder()
      .optionallyWith(
        id.map(value => SecurityProfileId.unwrap(value): java.lang.String)
      )(_.id)
      .optionallyWith(arn.map(value => ARN.unwrap(value): java.lang.String))(
        _.arn
      )
      .optionallyWith(
        name.map(value => SecurityProfileName.unwrap(value): java.lang.String)
      )(_.name)
      .build()
  }
  def asReadOnly: zio.aws.connect.model.SecurityProfileSummary.ReadOnly =
    zio.aws.connect.model.SecurityProfileSummary.wrap(buildAwsValue())
}
object SecurityProfileSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connect.model.SecurityProfileSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connect.model.SecurityProfileSummary =
      zio.aws.connect.model.SecurityProfileSummary(
        id.map(value => value),
        arn.map(value => value),
        name.map(value => value)
      )
    def id: Option[SecurityProfileId]
    def arn: Option[ARN]
    def name: Option[SecurityProfileName]
    def getId: ZIO[Any, AwsError, SecurityProfileId] =
      AwsError.unwrapOptionField("id", id)
    def getArn: ZIO[Any, AwsError, ARN] = AwsError.unwrapOptionField("arn", arn)
    def getName: ZIO[Any, AwsError, SecurityProfileName] =
      AwsError.unwrapOptionField("name", name)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connect.model.SecurityProfileSummary
  ) extends zio.aws.connect.model.SecurityProfileSummary.ReadOnly {
    override val id: Option[SecurityProfileId] = scala
      .Option(impl.id())
      .map(value => zio.aws.connect.model.primitives.SecurityProfileId(value))
    override val arn: Option[ARN] = scala
      .Option(impl.arn())
      .map(value => zio.aws.connect.model.primitives.ARN(value))
    override val name: Option[SecurityProfileName] = scala
      .Option(impl.name())
      .map(value => zio.aws.connect.model.primitives.SecurityProfileName(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.connect.model.SecurityProfileSummary
  ): zio.aws.connect.model.SecurityProfileSummary.ReadOnly = new Wrapper(impl)
}
