package zio.aws.connect.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.connect.model.primitives.{
  AttributeName,
  InstanceId,
  ClientToken,
  ContactFlowId,
  AttributeValue
}
import scala.jdk.CollectionConverters._
final case class StartChatContactRequest(
    instanceId: InstanceId,
    contactFlowId: ContactFlowId,
    attributes: Option[Map[AttributeName, AttributeValue]] = None,
    participantDetails: zio.aws.connect.model.ParticipantDetails,
    initialMessage: Option[zio.aws.connect.model.ChatMessage] = None,
    clientToken: Option[ClientToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connect.model.StartChatContactRequest = {
    import StartChatContactRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connect.model.StartChatContactRequest
      .builder()
      .instanceId(InstanceId.unwrap(instanceId): java.lang.String)
      .contactFlowId(ContactFlowId.unwrap(contactFlowId): java.lang.String)
      .optionallyWith(
        attributes.map(value =>
          value
            .map({ case (key, value) =>
              (AttributeName.unwrap(key): java.lang.String) -> (AttributeValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.attributes)
      .participantDetails(participantDetails.buildAwsValue())
      .optionallyWith(initialMessage.map(value => value.buildAwsValue()))(
        _.initialMessage
      )
      .optionallyWith(
        clientToken.map(value => ClientToken.unwrap(value): java.lang.String)
      )(_.clientToken)
      .build()
  }
  def asReadOnly: zio.aws.connect.model.StartChatContactRequest.ReadOnly =
    zio.aws.connect.model.StartChatContactRequest.wrap(buildAwsValue())
}
object StartChatContactRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connect.model.StartChatContactRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connect.model.StartChatContactRequest =
      zio.aws.connect.model.StartChatContactRequest(
        instanceId,
        contactFlowId,
        attributes.map(value => value),
        participantDetails.asEditable,
        initialMessage.map(value => value.asEditable),
        clientToken.map(value => value)
      )
    def instanceId: InstanceId
    def contactFlowId: ContactFlowId
    def attributes: Option[Map[AttributeName, AttributeValue]]
    def participantDetails: zio.aws.connect.model.ParticipantDetails.ReadOnly
    def initialMessage: Option[zio.aws.connect.model.ChatMessage.ReadOnly]
    def clientToken: Option[ClientToken]
    def getInstanceId: ZIO[Any, Nothing, InstanceId] = ZIO.succeed(instanceId)
    def getContactFlowId: ZIO[Any, Nothing, ContactFlowId] =
      ZIO.succeed(contactFlowId)
    def getAttributes: ZIO[Any, AwsError, Map[AttributeName, AttributeValue]] =
      AwsError.unwrapOptionField("attributes", attributes)
    def getParticipantDetails
        : ZIO[Any, Nothing, zio.aws.connect.model.ParticipantDetails.ReadOnly] =
      ZIO.succeed(participantDetails)
    def getInitialMessage
        : ZIO[Any, AwsError, zio.aws.connect.model.ChatMessage.ReadOnly] =
      AwsError.unwrapOptionField("initialMessage", initialMessage)
    def getClientToken: ZIO[Any, AwsError, ClientToken] =
      AwsError.unwrapOptionField("clientToken", clientToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connect.model.StartChatContactRequest
  ) extends zio.aws.connect.model.StartChatContactRequest.ReadOnly {
    override val instanceId: InstanceId =
      zio.aws.connect.model.primitives.InstanceId(impl.instanceId())
    override val contactFlowId: ContactFlowId =
      zio.aws.connect.model.primitives.ContactFlowId(impl.contactFlowId())
    override val attributes: Option[Map[AttributeName, AttributeValue]] = scala
      .Option(impl.attributes())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.connect.model.primitives.AttributeName(
              key
            ) -> zio.aws.connect.model.primitives.AttributeValue(value)
          })
          .toMap
      )
    override val participantDetails
        : zio.aws.connect.model.ParticipantDetails.ReadOnly =
      zio.aws.connect.model.ParticipantDetails.wrap(impl.participantDetails())
    override val initialMessage
        : Option[zio.aws.connect.model.ChatMessage.ReadOnly] = scala
      .Option(impl.initialMessage())
      .map(value => zio.aws.connect.model.ChatMessage.wrap(value))
    override val clientToken: Option[ClientToken] = scala
      .Option(impl.clientToken())
      .map(value => zio.aws.connect.model.primitives.ClientToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.connect.model.StartChatContactRequest
  ): zio.aws.connect.model.StartChatContactRequest.ReadOnly = new Wrapper(impl)
}
