package zio.aws.connect.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.connect.model.primitives.{ContactId, InstanceId}
import scala.jdk.CollectionConverters._
final case class StartContactRecordingRequest(
    instanceId: InstanceId,
    contactId: ContactId,
    initialContactId: ContactId,
    voiceRecordingConfiguration: zio.aws.connect.model.VoiceRecordingConfiguration
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connect.model.StartContactRecordingRequest = {
    import StartContactRecordingRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connect.model.StartContactRecordingRequest
      .builder()
      .instanceId(InstanceId.unwrap(instanceId): java.lang.String)
      .contactId(ContactId.unwrap(contactId): java.lang.String)
      .initialContactId(ContactId.unwrap(initialContactId): java.lang.String)
      .voiceRecordingConfiguration(voiceRecordingConfiguration.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.connect.model.StartContactRecordingRequest.ReadOnly =
    zio.aws.connect.model.StartContactRecordingRequest.wrap(buildAwsValue())
}
object StartContactRecordingRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connect.model.StartContactRecordingRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connect.model.StartContactRecordingRequest =
      zio.aws.connect.model.StartContactRecordingRequest(
        instanceId,
        contactId,
        initialContactId,
        voiceRecordingConfiguration.asEditable
      )
    def instanceId: InstanceId
    def contactId: ContactId
    def initialContactId: ContactId
    def voiceRecordingConfiguration
        : zio.aws.connect.model.VoiceRecordingConfiguration.ReadOnly
    def getInstanceId: ZIO[Any, Nothing, InstanceId] = ZIO.succeed(instanceId)
    def getContactId: ZIO[Any, Nothing, ContactId] = ZIO.succeed(contactId)
    def getInitialContactId: ZIO[Any, Nothing, ContactId] =
      ZIO.succeed(initialContactId)
    def getVoiceRecordingConfiguration: ZIO[
      Any,
      Nothing,
      zio.aws.connect.model.VoiceRecordingConfiguration.ReadOnly
    ] = ZIO.succeed(voiceRecordingConfiguration)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connect.model.StartContactRecordingRequest
  ) extends zio.aws.connect.model.StartContactRecordingRequest.ReadOnly {
    override val instanceId: InstanceId =
      zio.aws.connect.model.primitives.InstanceId(impl.instanceId())
    override val contactId: ContactId =
      zio.aws.connect.model.primitives.ContactId(impl.contactId())
    override val initialContactId: ContactId =
      zio.aws.connect.model.primitives.ContactId(impl.initialContactId())
    override val voiceRecordingConfiguration
        : zio.aws.connect.model.VoiceRecordingConfiguration.ReadOnly =
      zio.aws.connect.model.VoiceRecordingConfiguration
        .wrap(impl.voiceRecordingConfiguration())
  }
  def wrap(
      impl: software.amazon.awssdk.services.connect.model.StartContactRecordingRequest
  ): zio.aws.connect.model.StartContactRecordingRequest.ReadOnly = new Wrapper(
    impl
  )
}
