package zio.aws.connect.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.connect.model.primitives.StreamingId
import scala.jdk.CollectionConverters._
final case class StartContactStreamingResponse(streamingId: StreamingId) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connect.model.StartContactStreamingResponse = {
    import StartContactStreamingResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connect.model.StartContactStreamingResponse
      .builder()
      .streamingId(StreamingId.unwrap(streamingId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.connect.model.StartContactStreamingResponse.ReadOnly =
    zio.aws.connect.model.StartContactStreamingResponse.wrap(buildAwsValue())
}
object StartContactStreamingResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connect.model.StartContactStreamingResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connect.model.StartContactStreamingResponse =
      zio.aws.connect.model.StartContactStreamingResponse(streamingId)
    def streamingId: StreamingId
    def getStreamingId: ZIO[Any, Nothing, StreamingId] =
      ZIO.succeed(streamingId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connect.model.StartContactStreamingResponse
  ) extends zio.aws.connect.model.StartContactStreamingResponse.ReadOnly {
    override val streamingId: StreamingId =
      zio.aws.connect.model.primitives.StreamingId(impl.streamingId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.connect.model.StartContactStreamingResponse
  ): zio.aws.connect.model.StartContactStreamingResponse.ReadOnly = new Wrapper(
    impl
  )
}
