package zio.aws.connect.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import zio.aws.connect.model.primitives.{
  AttributeName,
  InstanceId,
  Timestamp,
  ReferenceKey,
  Description,
  ContactId,
  ClientToken,
  ContactFlowId,
  Name,
  AttributeValue
}
import scala.jdk.CollectionConverters._
final case class StartTaskContactRequest(
    instanceId: InstanceId,
    previousContactId: Option[ContactId] = None,
    contactFlowId: ContactFlowId,
    attributes: Option[Map[AttributeName, AttributeValue]] = None,
    name: Name,
    references: Option[Map[ReferenceKey, zio.aws.connect.model.Reference]] =
      None,
    description: Option[Description] = None,
    clientToken: Option[ClientToken] = None,
    scheduledTime: Option[Timestamp] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connect.model.StartTaskContactRequest = {
    import StartTaskContactRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connect.model.StartTaskContactRequest
      .builder()
      .instanceId(InstanceId.unwrap(instanceId): java.lang.String)
      .optionallyWith(
        previousContactId.map(value =>
          ContactId.unwrap(value): java.lang.String
        )
      )(_.previousContactId)
      .contactFlowId(ContactFlowId.unwrap(contactFlowId): java.lang.String)
      .optionallyWith(
        attributes.map(value =>
          value
            .map({ case (key, value) =>
              (AttributeName.unwrap(key): java.lang.String) -> (AttributeValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.attributes)
      .name(Name.unwrap(name): java.lang.String)
      .optionallyWith(
        references.map(value =>
          value
            .map({ case (key, value) =>
              (ReferenceKey.unwrap(key): java.lang.String) -> value
                .buildAwsValue()
            })
            .asJava
        )
      )(_.references)
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .optionallyWith(
        clientToken.map(value => ClientToken.unwrap(value): java.lang.String)
      )(_.clientToken)
      .optionallyWith(
        scheduledTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.scheduledTime)
      .build()
  }
  def asReadOnly: zio.aws.connect.model.StartTaskContactRequest.ReadOnly =
    zio.aws.connect.model.StartTaskContactRequest.wrap(buildAwsValue())
}
object StartTaskContactRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connect.model.StartTaskContactRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connect.model.StartTaskContactRequest =
      zio.aws.connect.model.StartTaskContactRequest(
        instanceId,
        previousContactId.map(value => value),
        contactFlowId,
        attributes.map(value => value),
        name,
        references.map(value =>
          value.map({ case (key, value) =>
            key -> value.asEditable
          })
        ),
        description.map(value => value),
        clientToken.map(value => value),
        scheduledTime.map(value => value)
      )
    def instanceId: InstanceId
    def previousContactId: Option[ContactId]
    def contactFlowId: ContactFlowId
    def attributes: Option[Map[AttributeName, AttributeValue]]
    def name: Name
    def references
        : Option[Map[ReferenceKey, zio.aws.connect.model.Reference.ReadOnly]]
    def description: Option[Description]
    def clientToken: Option[ClientToken]
    def scheduledTime: Option[Timestamp]
    def getInstanceId: ZIO[Any, Nothing, InstanceId] = ZIO.succeed(instanceId)
    def getPreviousContactId: ZIO[Any, AwsError, ContactId] =
      AwsError.unwrapOptionField("previousContactId", previousContactId)
    def getContactFlowId: ZIO[Any, Nothing, ContactFlowId] =
      ZIO.succeed(contactFlowId)
    def getAttributes: ZIO[Any, AwsError, Map[AttributeName, AttributeValue]] =
      AwsError.unwrapOptionField("attributes", attributes)
    def getName: ZIO[Any, Nothing, Name] = ZIO.succeed(name)
    def getReferences: ZIO[Any, AwsError, Map[
      ReferenceKey,
      zio.aws.connect.model.Reference.ReadOnly
    ]] = AwsError.unwrapOptionField("references", references)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getClientToken: ZIO[Any, AwsError, ClientToken] =
      AwsError.unwrapOptionField("clientToken", clientToken)
    def getScheduledTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("scheduledTime", scheduledTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connect.model.StartTaskContactRequest
  ) extends zio.aws.connect.model.StartTaskContactRequest.ReadOnly {
    override val instanceId: InstanceId =
      zio.aws.connect.model.primitives.InstanceId(impl.instanceId())
    override val previousContactId: Option[ContactId] = scala
      .Option(impl.previousContactId())
      .map(value => zio.aws.connect.model.primitives.ContactId(value))
    override val contactFlowId: ContactFlowId =
      zio.aws.connect.model.primitives.ContactFlowId(impl.contactFlowId())
    override val attributes: Option[Map[AttributeName, AttributeValue]] = scala
      .Option(impl.attributes())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.connect.model.primitives.AttributeName(
              key
            ) -> zio.aws.connect.model.primitives.AttributeValue(value)
          })
          .toMap
      )
    override val name: Name = zio.aws.connect.model.primitives.Name(impl.name())
    override val references
        : Option[Map[ReferenceKey, zio.aws.connect.model.Reference.ReadOnly]] =
      scala
        .Option(impl.references())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              zio.aws.connect.model.primitives.ReferenceKey(
                key
              ) -> zio.aws.connect.model.Reference.wrap(value)
            })
            .toMap
        )
    override val description: Option[Description] = scala
      .Option(impl.description())
      .map(value => zio.aws.connect.model.primitives.Description(value))
    override val clientToken: Option[ClientToken] = scala
      .Option(impl.clientToken())
      .map(value => zio.aws.connect.model.primitives.ClientToken(value))
    override val scheduledTime: Option[Timestamp] = scala
      .Option(impl.scheduledTime())
      .map(value => zio.aws.connect.model.primitives.Timestamp(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.connect.model.StartTaskContactRequest
  ): zio.aws.connect.model.StartTaskContactRequest.ReadOnly = new Wrapper(impl)
}
