package zio.aws.connect.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.connect.model.primitives.ContactId
import scala.jdk.CollectionConverters._
final case class StartTaskContactResponse(contactId: Option[ContactId] = None) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connect.model.StartTaskContactResponse = {
    import StartTaskContactResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connect.model.StartTaskContactResponse
      .builder()
      .optionallyWith(
        contactId.map(value => ContactId.unwrap(value): java.lang.String)
      )(_.contactId)
      .build()
  }
  def asReadOnly: zio.aws.connect.model.StartTaskContactResponse.ReadOnly =
    zio.aws.connect.model.StartTaskContactResponse.wrap(buildAwsValue())
}
object StartTaskContactResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connect.model.StartTaskContactResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connect.model.StartTaskContactResponse =
      zio.aws.connect.model
        .StartTaskContactResponse(contactId.map(value => value))
    def contactId: Option[ContactId]
    def getContactId: ZIO[Any, AwsError, ContactId] =
      AwsError.unwrapOptionField("contactId", contactId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connect.model.StartTaskContactResponse
  ) extends zio.aws.connect.model.StartTaskContactResponse.ReadOnly {
    override val contactId: Option[ContactId] = scala
      .Option(impl.contactId())
      .map(value => zio.aws.connect.model.primitives.ContactId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.connect.model.StartTaskContactResponse
  ): zio.aws.connect.model.StartTaskContactResponse.ReadOnly = new Wrapper(impl)
}
