package zio.aws.connect.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.connect.model.primitives.{TagValue, TagKey, ARN}
import scala.jdk.CollectionConverters._
final case class TagResourceRequest(
    resourceArn: ARN,
    tags: Map[TagKey, TagValue]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connect.model.TagResourceRequest = {
    import TagResourceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connect.model.TagResourceRequest
      .builder()
      .resourceArn(ARN.unwrap(resourceArn): java.lang.String)
      .tags(
        tags
          .map({ case (key, value) =>
            (TagKey.unwrap(key): java.lang.String) -> (TagValue
              .unwrap(value): java.lang.String)
          })
          .asJava
      )
      .build()
  }
  def asReadOnly: zio.aws.connect.model.TagResourceRequest.ReadOnly =
    zio.aws.connect.model.TagResourceRequest.wrap(buildAwsValue())
}
object TagResourceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connect.model.TagResourceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connect.model.TagResourceRequest =
      zio.aws.connect.model.TagResourceRequest(resourceArn, tags)
    def resourceArn: ARN
    def tags: Map[TagKey, TagValue]
    def getResourceArn: ZIO[Any, Nothing, ARN] = ZIO.succeed(resourceArn)
    def getTags: ZIO[Any, Nothing, Map[TagKey, TagValue]] = ZIO.succeed(tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connect.model.TagResourceRequest
  ) extends zio.aws.connect.model.TagResourceRequest.ReadOnly {
    override val resourceArn: ARN =
      zio.aws.connect.model.primitives.ARN(impl.resourceArn())
    override val tags: Map[TagKey, TagValue] = impl
      .tags()
      .asScala
      .map({ case (key, value) =>
        zio.aws.connect.model.primitives
          .TagKey(key) -> zio.aws.connect.model.primitives.TagValue(value)
      })
      .toMap
  }
  def wrap(
      impl: software.amazon.awssdk.services.connect.model.TagResourceRequest
  ): zio.aws.connect.model.TagResourceRequest.ReadOnly = new Wrapper(impl)
}
