package zio.aws.connect.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.connect.model.primitives.ThresholdValue
import scala.jdk.CollectionConverters._
final case class Threshold(
    comparison: Option[zio.aws.connect.model.Comparison] = None,
    thresholdValue: Option[ThresholdValue] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connect.model.Threshold = {
    import Threshold.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connect.model.Threshold
      .builder()
      .optionallyWith(comparison.map(value => value.unwrap))(_.comparison)
      .optionallyWith(
        thresholdValue.map(value =>
          ThresholdValue.unwrap(value): java.lang.Double
        )
      )(_.thresholdValue)
      .build()
  }
  def asReadOnly: zio.aws.connect.model.Threshold.ReadOnly =
    zio.aws.connect.model.Threshold.wrap(buildAwsValue())
}
object Threshold {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.connect.model.Threshold] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connect.model.Threshold =
      zio.aws.connect.model.Threshold(
        comparison.map(value => value),
        thresholdValue.map(value => value)
      )
    def comparison: Option[zio.aws.connect.model.Comparison]
    def thresholdValue: Option[ThresholdValue]
    def getComparison: ZIO[Any, AwsError, zio.aws.connect.model.Comparison] =
      AwsError.unwrapOptionField("comparison", comparison)
    def getThresholdValue: ZIO[Any, AwsError, ThresholdValue] =
      AwsError.unwrapOptionField("thresholdValue", thresholdValue)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connect.model.Threshold
  ) extends zio.aws.connect.model.Threshold.ReadOnly {
    override val comparison: Option[zio.aws.connect.model.Comparison] = scala
      .Option(impl.comparison())
      .map(value => zio.aws.connect.model.Comparison.wrap(value))
    override val thresholdValue: Option[ThresholdValue] = scala
      .Option(impl.thresholdValue())
      .map(value => zio.aws.connect.model.primitives.ThresholdValue(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.connect.model.Threshold
  ): zio.aws.connect.model.Threshold.ReadOnly = new Wrapper(impl)
}
