package zio.aws.connect.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.connect.model.primitives.{
  ContactFlowContent,
  ContactFlowId,
  InstanceId
}
import scala.jdk.CollectionConverters._
final case class UpdateContactFlowContentRequest(
    instanceId: InstanceId,
    contactFlowId: ContactFlowId,
    content: ContactFlowContent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connect.model.UpdateContactFlowContentRequest = {
    import UpdateContactFlowContentRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connect.model.UpdateContactFlowContentRequest
      .builder()
      .instanceId(InstanceId.unwrap(instanceId): java.lang.String)
      .contactFlowId(ContactFlowId.unwrap(contactFlowId): java.lang.String)
      .content(ContactFlowContent.unwrap(content): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.connect.model.UpdateContactFlowContentRequest.ReadOnly =
    zio.aws.connect.model.UpdateContactFlowContentRequest.wrap(buildAwsValue())
}
object UpdateContactFlowContentRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connect.model.UpdateContactFlowContentRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connect.model.UpdateContactFlowContentRequest =
      zio.aws.connect.model
        .UpdateContactFlowContentRequest(instanceId, contactFlowId, content)
    def instanceId: InstanceId
    def contactFlowId: ContactFlowId
    def content: ContactFlowContent
    def getInstanceId: ZIO[Any, Nothing, InstanceId] = ZIO.succeed(instanceId)
    def getContactFlowId: ZIO[Any, Nothing, ContactFlowId] =
      ZIO.succeed(contactFlowId)
    def getContent: ZIO[Any, Nothing, ContactFlowContent] = ZIO.succeed(content)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connect.model.UpdateContactFlowContentRequest
  ) extends zio.aws.connect.model.UpdateContactFlowContentRequest.ReadOnly {
    override val instanceId: InstanceId =
      zio.aws.connect.model.primitives.InstanceId(impl.instanceId())
    override val contactFlowId: ContactFlowId =
      zio.aws.connect.model.primitives.ContactFlowId(impl.contactFlowId())
    override val content: ContactFlowContent =
      zio.aws.connect.model.primitives.ContactFlowContent(impl.content())
  }
  def wrap(
      impl: software.amazon.awssdk.services.connect.model.UpdateContactFlowContentRequest
  ): zio.aws.connect.model.UpdateContactFlowContentRequest.ReadOnly =
    new Wrapper(impl)
}
