package zio.aws.connect.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.connect.model.primitives.{
  ContactFlowDescription,
  ContactFlowName,
  ContactFlowId,
  InstanceId
}
import scala.jdk.CollectionConverters._
final case class UpdateContactFlowMetadataRequest(
    instanceId: InstanceId,
    contactFlowId: ContactFlowId,
    name: Option[ContactFlowName] = None,
    description: Option[ContactFlowDescription] = None,
    contactFlowState: Option[zio.aws.connect.model.ContactFlowState] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connect.model.UpdateContactFlowMetadataRequest = {
    import UpdateContactFlowMetadataRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connect.model.UpdateContactFlowMetadataRequest
      .builder()
      .instanceId(InstanceId.unwrap(instanceId): java.lang.String)
      .contactFlowId(ContactFlowId.unwrap(contactFlowId): java.lang.String)
      .optionallyWith(
        name.map(value => ContactFlowName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        description.map(value =>
          ContactFlowDescription.unwrap(value): java.lang.String
        )
      )(_.description)
      .optionallyWith(contactFlowState.map(value => value.unwrap))(
        _.contactFlowState
      )
      .build()
  }
  def asReadOnly
      : zio.aws.connect.model.UpdateContactFlowMetadataRequest.ReadOnly =
    zio.aws.connect.model.UpdateContactFlowMetadataRequest.wrap(buildAwsValue())
}
object UpdateContactFlowMetadataRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connect.model.UpdateContactFlowMetadataRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connect.model.UpdateContactFlowMetadataRequest =
      zio.aws.connect.model.UpdateContactFlowMetadataRequest(
        instanceId,
        contactFlowId,
        name.map(value => value),
        description.map(value => value),
        contactFlowState.map(value => value)
      )
    def instanceId: InstanceId
    def contactFlowId: ContactFlowId
    def name: Option[ContactFlowName]
    def description: Option[ContactFlowDescription]
    def contactFlowState: Option[zio.aws.connect.model.ContactFlowState]
    def getInstanceId: ZIO[Any, Nothing, InstanceId] = ZIO.succeed(instanceId)
    def getContactFlowId: ZIO[Any, Nothing, ContactFlowId] =
      ZIO.succeed(contactFlowId)
    def getName: ZIO[Any, AwsError, ContactFlowName] =
      AwsError.unwrapOptionField("name", name)
    def getDescription: ZIO[Any, AwsError, ContactFlowDescription] =
      AwsError.unwrapOptionField("description", description)
    def getContactFlowState
        : ZIO[Any, AwsError, zio.aws.connect.model.ContactFlowState] =
      AwsError.unwrapOptionField("contactFlowState", contactFlowState)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connect.model.UpdateContactFlowMetadataRequest
  ) extends zio.aws.connect.model.UpdateContactFlowMetadataRequest.ReadOnly {
    override val instanceId: InstanceId =
      zio.aws.connect.model.primitives.InstanceId(impl.instanceId())
    override val contactFlowId: ContactFlowId =
      zio.aws.connect.model.primitives.ContactFlowId(impl.contactFlowId())
    override val name: Option[ContactFlowName] = scala
      .Option(impl.name())
      .map(value => zio.aws.connect.model.primitives.ContactFlowName(value))
    override val description: Option[ContactFlowDescription] = scala
      .Option(impl.description())
      .map(value =>
        zio.aws.connect.model.primitives.ContactFlowDescription(value)
      )
    override val contactFlowState
        : Option[zio.aws.connect.model.ContactFlowState] = scala
      .Option(impl.contactFlowState())
      .map(value => zio.aws.connect.model.ContactFlowState.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.connect.model.UpdateContactFlowMetadataRequest
  ): zio.aws.connect.model.UpdateContactFlowMetadataRequest.ReadOnly =
    new Wrapper(impl)
}
