package zio.aws.connect.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.connect.model.primitives.{
  HoursOfOperationId,
  InstanceId,
  TimeZone,
  UpdateHoursOfOperationDescription,
  CommonNameLength127
}
import scala.jdk.CollectionConverters._
final case class UpdateHoursOfOperationRequest(
    instanceId: InstanceId,
    hoursOfOperationId: HoursOfOperationId,
    name: Option[CommonNameLength127] = None,
    description: Option[UpdateHoursOfOperationDescription] = None,
    timeZone: Option[TimeZone] = None,
    config: Option[Iterable[zio.aws.connect.model.HoursOfOperationConfig]] =
      None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connect.model.UpdateHoursOfOperationRequest = {
    import UpdateHoursOfOperationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connect.model.UpdateHoursOfOperationRequest
      .builder()
      .instanceId(InstanceId.unwrap(instanceId): java.lang.String)
      .hoursOfOperationId(
        HoursOfOperationId.unwrap(hoursOfOperationId): java.lang.String
      )
      .optionallyWith(
        name.map(value => CommonNameLength127.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        description.map(value =>
          UpdateHoursOfOperationDescription.unwrap(value): java.lang.String
        )
      )(_.description)
      .optionallyWith(
        timeZone.map(value => TimeZone.unwrap(value): java.lang.String)
      )(_.timeZone)
      .optionallyWith(
        config.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.config)
      .build()
  }
  def asReadOnly: zio.aws.connect.model.UpdateHoursOfOperationRequest.ReadOnly =
    zio.aws.connect.model.UpdateHoursOfOperationRequest.wrap(buildAwsValue())
}
object UpdateHoursOfOperationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connect.model.UpdateHoursOfOperationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connect.model.UpdateHoursOfOperationRequest =
      zio.aws.connect.model.UpdateHoursOfOperationRequest(
        instanceId,
        hoursOfOperationId,
        name.map(value => value),
        description.map(value => value),
        timeZone.map(value => value),
        config.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def instanceId: InstanceId
    def hoursOfOperationId: HoursOfOperationId
    def name: Option[CommonNameLength127]
    def description: Option[UpdateHoursOfOperationDescription]
    def timeZone: Option[TimeZone]
    def config
        : Option[List[zio.aws.connect.model.HoursOfOperationConfig.ReadOnly]]
    def getInstanceId: ZIO[Any, Nothing, InstanceId] = ZIO.succeed(instanceId)
    def getHoursOfOperationId: ZIO[Any, Nothing, HoursOfOperationId] =
      ZIO.succeed(hoursOfOperationId)
    def getName: ZIO[Any, AwsError, CommonNameLength127] =
      AwsError.unwrapOptionField("name", name)
    def getDescription: ZIO[Any, AwsError, UpdateHoursOfOperationDescription] =
      AwsError.unwrapOptionField("description", description)
    def getTimeZone: ZIO[Any, AwsError, TimeZone] =
      AwsError.unwrapOptionField("timeZone", timeZone)
    def getConfig: ZIO[Any, AwsError, List[
      zio.aws.connect.model.HoursOfOperationConfig.ReadOnly
    ]] = AwsError.unwrapOptionField("config", config)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connect.model.UpdateHoursOfOperationRequest
  ) extends zio.aws.connect.model.UpdateHoursOfOperationRequest.ReadOnly {
    override val instanceId: InstanceId =
      zio.aws.connect.model.primitives.InstanceId(impl.instanceId())
    override val hoursOfOperationId: HoursOfOperationId =
      zio.aws.connect.model.primitives
        .HoursOfOperationId(impl.hoursOfOperationId())
    override val name: Option[CommonNameLength127] = scala
      .Option(impl.name())
      .map(value => zio.aws.connect.model.primitives.CommonNameLength127(value))
    override val description: Option[UpdateHoursOfOperationDescription] = scala
      .Option(impl.description())
      .map(value =>
        zio.aws.connect.model.primitives
          .UpdateHoursOfOperationDescription(value)
      )
    override val timeZone: Option[TimeZone] = scala
      .Option(impl.timeZone())
      .map(value => zio.aws.connect.model.primitives.TimeZone(value))
    override val config
        : Option[List[zio.aws.connect.model.HoursOfOperationConfig.ReadOnly]] =
      scala
        .Option(impl.config())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.connect.model.HoursOfOperationConfig.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.connect.model.UpdateHoursOfOperationRequest
  ): zio.aws.connect.model.UpdateHoursOfOperationRequest.ReadOnly = new Wrapper(
    impl
  )
}
