package zio.aws.connect.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.connect.model.primitives.{AssociationId, InstanceId}
import scala.jdk.CollectionConverters._
final case class UpdateInstanceStorageConfigRequest(
    instanceId: InstanceId,
    associationId: AssociationId,
    resourceType: zio.aws.connect.model.InstanceStorageResourceType,
    storageConfig: zio.aws.connect.model.InstanceStorageConfig
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connect.model.UpdateInstanceStorageConfigRequest = {
    import UpdateInstanceStorageConfigRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connect.model.UpdateInstanceStorageConfigRequest
      .builder()
      .instanceId(InstanceId.unwrap(instanceId): java.lang.String)
      .associationId(AssociationId.unwrap(associationId): java.lang.String)
      .resourceType(resourceType.unwrap)
      .storageConfig(storageConfig.buildAwsValue())
      .build()
  }
  def asReadOnly
      : zio.aws.connect.model.UpdateInstanceStorageConfigRequest.ReadOnly =
    zio.aws.connect.model.UpdateInstanceStorageConfigRequest
      .wrap(buildAwsValue())
}
object UpdateInstanceStorageConfigRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connect.model.UpdateInstanceStorageConfigRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connect.model.UpdateInstanceStorageConfigRequest =
      zio.aws.connect.model.UpdateInstanceStorageConfigRequest(
        instanceId,
        associationId,
        resourceType,
        storageConfig.asEditable
      )
    def instanceId: InstanceId
    def associationId: AssociationId
    def resourceType: zio.aws.connect.model.InstanceStorageResourceType
    def storageConfig: zio.aws.connect.model.InstanceStorageConfig.ReadOnly
    def getInstanceId: ZIO[Any, Nothing, InstanceId] = ZIO.succeed(instanceId)
    def getAssociationId: ZIO[Any, Nothing, AssociationId] =
      ZIO.succeed(associationId)
    def getResourceType
        : ZIO[Any, Nothing, zio.aws.connect.model.InstanceStorageResourceType] =
      ZIO.succeed(resourceType)
    def getStorageConfig: ZIO[
      Any,
      Nothing,
      zio.aws.connect.model.InstanceStorageConfig.ReadOnly
    ] = ZIO.succeed(storageConfig)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connect.model.UpdateInstanceStorageConfigRequest
  ) extends zio.aws.connect.model.UpdateInstanceStorageConfigRequest.ReadOnly {
    override val instanceId: InstanceId =
      zio.aws.connect.model.primitives.InstanceId(impl.instanceId())
    override val associationId: AssociationId =
      zio.aws.connect.model.primitives.AssociationId(impl.associationId())
    override val resourceType
        : zio.aws.connect.model.InstanceStorageResourceType =
      zio.aws.connect.model.InstanceStorageResourceType
        .wrap(impl.resourceType())
    override val storageConfig
        : zio.aws.connect.model.InstanceStorageConfig.ReadOnly =
      zio.aws.connect.model.InstanceStorageConfig.wrap(impl.storageConfig())
  }
  def wrap(
      impl: software.amazon.awssdk.services.connect.model.UpdateInstanceStorageConfigRequest
  ): zio.aws.connect.model.UpdateInstanceStorageConfigRequest.ReadOnly =
    new Wrapper(impl)
}
