package zio.aws.connect.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.connect.model.primitives.{
  HoursOfOperationId,
  QueueId,
  InstanceId
}
import scala.jdk.CollectionConverters._
final case class UpdateQueueHoursOfOperationRequest(
    instanceId: InstanceId,
    queueId: QueueId,
    hoursOfOperationId: HoursOfOperationId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connect.model.UpdateQueueHoursOfOperationRequest = {
    import UpdateQueueHoursOfOperationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connect.model.UpdateQueueHoursOfOperationRequest
      .builder()
      .instanceId(InstanceId.unwrap(instanceId): java.lang.String)
      .queueId(QueueId.unwrap(queueId): java.lang.String)
      .hoursOfOperationId(
        HoursOfOperationId.unwrap(hoursOfOperationId): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.connect.model.UpdateQueueHoursOfOperationRequest.ReadOnly =
    zio.aws.connect.model.UpdateQueueHoursOfOperationRequest
      .wrap(buildAwsValue())
}
object UpdateQueueHoursOfOperationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connect.model.UpdateQueueHoursOfOperationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connect.model.UpdateQueueHoursOfOperationRequest =
      zio.aws.connect.model.UpdateQueueHoursOfOperationRequest(
        instanceId,
        queueId,
        hoursOfOperationId
      )
    def instanceId: InstanceId
    def queueId: QueueId
    def hoursOfOperationId: HoursOfOperationId
    def getInstanceId: ZIO[Any, Nothing, InstanceId] = ZIO.succeed(instanceId)
    def getQueueId: ZIO[Any, Nothing, QueueId] = ZIO.succeed(queueId)
    def getHoursOfOperationId: ZIO[Any, Nothing, HoursOfOperationId] =
      ZIO.succeed(hoursOfOperationId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connect.model.UpdateQueueHoursOfOperationRequest
  ) extends zio.aws.connect.model.UpdateQueueHoursOfOperationRequest.ReadOnly {
    override val instanceId: InstanceId =
      zio.aws.connect.model.primitives.InstanceId(impl.instanceId())
    override val queueId: QueueId =
      zio.aws.connect.model.primitives.QueueId(impl.queueId())
    override val hoursOfOperationId: HoursOfOperationId =
      zio.aws.connect.model.primitives
        .HoursOfOperationId(impl.hoursOfOperationId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.connect.model.UpdateQueueHoursOfOperationRequest
  ): zio.aws.connect.model.UpdateQueueHoursOfOperationRequest.ReadOnly =
    new Wrapper(impl)
}
