package zio.aws.connect.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.connect.model.primitives.{QueueId, InstanceId}
import scala.jdk.CollectionConverters._
final case class UpdateQueueStatusRequest(
    instanceId: InstanceId,
    queueId: QueueId,
    status: zio.aws.connect.model.QueueStatus
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connect.model.UpdateQueueStatusRequest = {
    import UpdateQueueStatusRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connect.model.UpdateQueueStatusRequest
      .builder()
      .instanceId(InstanceId.unwrap(instanceId): java.lang.String)
      .queueId(QueueId.unwrap(queueId): java.lang.String)
      .status(status.unwrap)
      .build()
  }
  def asReadOnly: zio.aws.connect.model.UpdateQueueStatusRequest.ReadOnly =
    zio.aws.connect.model.UpdateQueueStatusRequest.wrap(buildAwsValue())
}
object UpdateQueueStatusRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connect.model.UpdateQueueStatusRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connect.model.UpdateQueueStatusRequest =
      zio.aws.connect.model
        .UpdateQueueStatusRequest(instanceId, queueId, status)
    def instanceId: InstanceId
    def queueId: QueueId
    def status: zio.aws.connect.model.QueueStatus
    def getInstanceId: ZIO[Any, Nothing, InstanceId] = ZIO.succeed(instanceId)
    def getQueueId: ZIO[Any, Nothing, QueueId] = ZIO.succeed(queueId)
    def getStatus: ZIO[Any, Nothing, zio.aws.connect.model.QueueStatus] =
      ZIO.succeed(status)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connect.model.UpdateQueueStatusRequest
  ) extends zio.aws.connect.model.UpdateQueueStatusRequest.ReadOnly {
    override val instanceId: InstanceId =
      zio.aws.connect.model.primitives.InstanceId(impl.instanceId())
    override val queueId: QueueId =
      zio.aws.connect.model.primitives.QueueId(impl.queueId())
    override val status: zio.aws.connect.model.QueueStatus =
      zio.aws.connect.model.QueueStatus.wrap(impl.status())
  }
  def wrap(
      impl: software.amazon.awssdk.services.connect.model.UpdateQueueStatusRequest
  ): zio.aws.connect.model.UpdateQueueStatusRequest.ReadOnly = new Wrapper(impl)
}
